/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class PagingComposite
extends Composite {
    private int currentPage;
    private volatile boolean isLazyLoadingBusy;
    private int maxPage;
    private int fetchSize;
    private static final int DEFAULT_PAGESTEP = 1;
    private ToolItem textToolItem;
    private int elementsCount;
    private GridData gd;

    public PagingComposite(Composite parent, int style) {
        super(parent, 2048);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)SWTHelper.createGridLayout(true, 1));
        this.gd = new GridData(4, 128, true, false);
        this.setLayoutData(this.gd);
        Composite main = new Composite((Composite)this, 0);
        main.setLayout((Layout)SWTHelper.createGridLayout(true, 1));
        main.setLayoutData((Object)new GridData(131072, 128, true, false));
        ToolBar toolBar = new ToolBar(main, 0x820000);
        ToolItem prevToolItem = new ToolItem(toolBar, 8);
        prevToolItem.setToolTipText("");
        prevToolItem.setImage(Images.IMG_PREVIOUS.getImage());
        prevToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagingComposite.this.mouseClicked(-1);
            }
        });
        this.textToolItem = new ToolItem(toolBar, 0x1000008);
        this.textToolItem.setToolTipText("");
        this.textToolItem.setText("");
        ToolItem nextToolItem = new ToolItem(toolBar, 8);
        nextToolItem.setToolTipText("");
        nextToolItem.setImage(Images.IMG_NEXT.getImage());
        nextToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PagingComposite.this.mouseClicked(1);
            }
        });
        this.setVisible(false);
        this.gd.exclude = true;
    }

    public void reset() {
        this.setup(0, 0, 0);
    }

    public void setup(int currentPage, int elementsCount, int fetchSize) {
        this.isLazyLoadingBusy = false;
        this.elementsCount = elementsCount;
        if (currentPage > 0 && elementsCount > fetchSize) {
            this.currentPage = currentPage;
            this.fetchSize = fetchSize;
            this.maxPage = fetchSize > 0 ? (int)Math.ceil((double)elementsCount / (double)fetchSize) : 0;
        } else {
            this.currentPage = 0;
            this.fetchSize = 0;
            this.maxPage = 0;
        }
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PagingComposite.this.refresh();
            }
        });
    }

    private void refresh() {
        if (!this.isDisposed()) {
            this.setVisible(this.currentPage > 0);
            if (this.textToolItem != null) {
                this.textToolItem.setText(String.valueOf(this.currentPage) + "/" + this.maxPage);
                this.textToolItem.setToolTipText("Gesamtanzahl: " + this.elementsCount);
            }
            this.gd.exclude = this.currentPage <= 0;
            this.getParent().layout(true, true);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public abstract void runPaging();

    private boolean doPaging(int newPage) {
        if (!this.isLazyLoadingBusy && newPage > 0 && newPage <= this.maxPage) {
            this.isLazyLoadingBusy = true;
            this.currentPage = newPage;
            return true;
        }
        return false;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void mouseClicked(final int pageStep) {
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PagingComposite.this.doPaging(PagingComposite.this.currentPage + pageStep)) {
                    PagingComposite.this.runPaging();
                    PagingComposite.this.refresh();
                    PagingComposite.this.isLazyLoadingBusy = false;
                }
            }
        });
    }
}

