/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.ui.views.controls.GenericSearchSelectionDialog;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.LoggerFactory;

public class GenericSelectionComposite
extends Composite
implements ISelectionProvider {
    private ListenerList<ISelectionChangedListener> selectionListeners = new ListenerList();
    private Function<String, List<?>> inputFunction;
    private List<?> input;
    private IStructuredSelection selection;
    private String shellTitle;
    private String title;
    private String message;
    private Label selectLabel;
    private Button selectButton;

    public GenericSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    public GenericSelectionComposite(Composite parent, int style, String shellTitle, String title, String message) {
        super(parent, style);
        this.shellTitle = shellTitle;
        this.title = title;
        this.message = message;
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.selectLabel = new Label((Composite)this, 0);
        this.selectLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectButton = new Button((Composite)this, 0);
        this.selectButton.setText("...");
        this.selectButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericSearchSelectionDialog dialog = null;
                if (GenericSelectionComposite.this.input != null && !GenericSelectionComposite.this.input.isEmpty()) {
                    dialog = new GenericSearchSelectionDialog(GenericSelectionComposite.this.getShell(), GenericSelectionComposite.this.input, GenericSelectionComposite.this.shellTitle, GenericSelectionComposite.this.title, GenericSelectionComposite.this.message, null, 32);
                } else if (GenericSelectionComposite.this.inputFunction != null) {
                    dialog = new GenericSearchSelectionDialog(GenericSelectionComposite.this.getShell(), GenericSelectionComposite.this.inputFunction, GenericSelectionComposite.this.shellTitle, GenericSelectionComposite.this.title, GenericSelectionComposite.this.message, null, 32);
                }
                if (dialog != null) {
                    if (GenericSelectionComposite.this.selection != null) {
                        dialog.setSelection(GenericSelectionComposite.this.selection.toList());
                    }
                    if (dialog.open() == 0) {
                        GenericSelectionComposite.this.setSelection((ISelection)dialog.getSelection());
                        GenericSelectionComposite.this.callSelectionListeners();
                    }
                }
            }
        });
    }

    protected void customSelection() {
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Custom selection not implemented");
    }

    private void updateLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.selection != null && !this.selection.isEmpty()) {
            for (Object object : this.selection.toList()) {
                String label = GenericSearchSelectionDialog.getLabel(object);
                if (label == null || label.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append(", ").append(label);
                    continue;
                }
                sb.append(label);
            }
            this.selectLabel.setText(sb.toString());
        } else {
            this.selectLabel.setText("");
        }
        this.getParent().layout();
    }

    public void setInput(List<?> input) {
        this.input = input;
    }

    public void setInputFunction(Function<String, List<?>> inputFunction) {
        this.inputFunction = inputFunction;
    }

    protected void callSelectionListeners() {
        Object[] listeners = this.selectionListeners.getListeners();
        if (listeners != null && listeners.length > 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ((ISelectionChangedListener)object).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
                ++n2;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.selection != null) {
            return this.selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            this.updateLabel();
        }
    }
}

