/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.model.Identifiable;
import ch.elexis.data.Brief;
import ch.elexis.data.PersistentObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenericSearchSelectionDialog
extends TitleAreaDialog {
    private Function<String, List<?>> inputFunction;
    private List<?> input;
    private List<Object> selection = new LinkedList<Object>();
    private String shellTitle;
    private String title;
    private String message;
    private Image image;
    private int style;
    private AbstractTableViewer structuredViewer;
    private SearchDataDialog filter;
    private UpdateFilterRunnable currentFilterRunnable;

    public GenericSearchSelectionDialog(Shell parentShell, List<?> input, String shellTitle, String title, String message, Image image, int style) {
        super(parentShell);
        this.shellTitle = shellTitle;
        this.title = title;
        this.message = message;
        this.input = input;
        this.image = image;
        this.style = style;
    }

    public GenericSearchSelectionDialog(Shell parentShell, Function<String, List<?>> inputFunction, String shellTitle, String title, String message, Image image, int style) {
        super(parentShell);
        this.shellTitle = shellTitle;
        this.title = title;
        this.message = message;
        this.inputFunction = inputFunction;
        this.image = image;
        this.style = style;
    }

    public void setSelection(List<Object> selection) {
        this.selection = new LinkedList<Object>(selection);
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection(this.selection);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.setTitleImage(this.image);
        Composite ret = (Composite)super.createDialogArea(parent);
        final Text text = new Text(ret, 2048);
        GridData textGridData = new GridData();
        textGridData.grabExcessVerticalSpace = false;
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        textGridData.verticalAlignment = 1;
        text.setLayoutData((Object)textGridData);
        if (this.input != null && this.input.size() < 1000) {
            Collections.sort(this.input, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof Brief) {
                        return ((PersistentObject)o1).getLabel().substring(11).compareToIgnoreCase(((PersistentObject)o2).getLabel().substring(11));
                    }
                    if (o1 instanceof PersistentObject) {
                        return ((PersistentObject)o1).getLabel().compareToIgnoreCase(((PersistentObject)o2).getLabel());
                    }
                    if (o1 instanceof Identifiable) {
                        return ((Identifiable)o1).getLabel().compareToIgnoreCase(((Identifiable)o2).getLabel());
                    }
                    return 0;
                }
            });
        }
        this.structuredViewer = this.style == 4 ? new TableViewer(ret, 0x10000000) : CheckboxTableViewer.newCheckList((Composite)ret, (int)0x10000000);
        GridData viewerGridData = new GridData(1808);
        viewerGridData.heightHint = 250;
        viewerGridData.widthHint = 300;
        ((TableViewer)this.structuredViewer).getTable().setLayoutData((Object)viewerGridData);
        this.structuredViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.structuredViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object elements) {
                if (elements instanceof PersistentObject) {
                    return ((PersistentObject)elements).getLabel();
                }
                if (elements instanceof Identifiable) {
                    return ((Identifiable)elements).getLabel();
                }
                if (elements != null) {
                    return elements.toString();
                }
                return null;
            }
        });
        if (this.input != null) {
            this.structuredViewer.setInput((Object)this.input.toArray());
        } else if (this.inputFunction != null) {
            this.structuredViewer.setInput(this.inputFunction.apply(""));
        }
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (GenericSearchSelectionDialog.this.currentFilterRunnable != null) {
                    GenericSearchSelectionDialog.this.currentFilterRunnable.cancelled = true;
                }
                GenericSearchSelectionDialog.this.currentFilterRunnable = new UpdateFilterRunnable(text.getText());
                Display.getCurrent().timerExec(500, (Runnable)GenericSearchSelectionDialog.this.currentFilterRunnable);
            }
        });
        this.filter = new SearchDataDialog();
        this.structuredViewer.addFilter((ViewerFilter)this.filter);
        this.structuredViewer.addDoubleClickListener(event -> this.okPressed());
        return ret;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.shellTitle);
    }

    protected void okPressed() {
        if (this.style == 4) {
            IStructuredSelection selection = this.structuredViewer.getStructuredSelection();
            this.selection = selection.toList();
        } else {
            this.selection = Arrays.asList(((CheckboxTableViewer)this.structuredViewer).getCheckedElements());
        }
        super.okPressed();
    }

    private void isLastElement(StructuredViewer structuredViewer) {
        if (((TableViewer)structuredViewer).getTable().getItems().length == 1) {
            ((TableViewer)structuredViewer).getTable().getItem(0).setChecked(true);
            ((TableViewer)structuredViewer).getTable().setSelection(0);
        } else {
            if (this.style != 4) {
                ((CheckboxTableViewer)structuredViewer).setAllChecked(false);
            }
            structuredViewer.setSelection(null);
        }
    }

    protected static String getLabel(Object object) {
        if (object instanceof PersistentObject) {
            return ((PersistentObject)object).getLabel();
        }
        if (object instanceof Identifiable) {
            return ((Identifiable)object).getLabel();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected boolean isResizable() {
        return true;
    }

    public static class SearchDataDialog
    extends ViewerFilter {
        private String searchString;

        public void setSearchText(String search) {
            this.searchString = search;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Identifiable identifiable;
            PersistentObject pObject;
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            return element instanceof PersistentObject ? (pObject = (PersistentObject)element).getLabel().toLowerCase().contains(this.searchString.toLowerCase()) : (element instanceof Identifiable ? (identifiable = (Identifiable)element).getLabel().toLowerCase().contains(this.searchString.toLowerCase()) : element != null && element.toString().toLowerCase().contains(this.searchString.toLowerCase()));
        }
    }

    private class UpdateFilterRunnable
    implements Runnable {
        private boolean cancelled = false;
        private String text;

        public UpdateFilterRunnable(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            if (!this.cancelled && GenericSearchSelectionDialog.this.structuredViewer != null && GenericSearchSelectionDialog.this.structuredViewer.getControl() != null && !GenericSearchSelectionDialog.this.structuredViewer.getControl().isDisposed()) {
                if (GenericSearchSelectionDialog.this.input != null) {
                    GenericSearchSelectionDialog.this.filter.setSearchText(this.text);
                    GenericSearchSelectionDialog.this.structuredViewer.refresh();
                    GenericSearchSelectionDialog.this.isLastElement((StructuredViewer)GenericSearchSelectionDialog.this.structuredViewer);
                } else if (GenericSearchSelectionDialog.this.inputFunction != null) {
                    GenericSearchSelectionDialog.this.structuredViewer.setInput(GenericSearchSelectionDialog.this.inputFunction.apply(this.text));
                    GenericSearchSelectionDialog.this.isLastElement((StructuredViewer)GenericSearchSelectionDialog.this.structuredViewer);
                }
            }
        }
    }
}

