/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.util.GenericObjectDragSource;
import ch.elexis.core.ui.views.codesystems.Messages;
import ch.elexis.data.PersistentObject;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CodeElementStatisticsComposite
extends Composite {
    private Label title;
    private TableViewer viewer;
    private String elexisClassName;
    private IContact contact;

    public CodeElementStatisticsComposite(String elexisClassName, Composite parent, int style) {
        super(parent, style);
        this.elexisClassName = elexisClassName;
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.title = new Label((Composite)this, 0);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.viewer = new TableViewer((Composite)this, 68354);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PersistentObject) {
                    return ((PersistentObject)element).getLabel();
                }
                if (element instanceof Identifiable) {
                    return ((Identifiable)element).getLabel();
                }
                return super.getText(element);
            }
        });
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ClearStatisticAction());
            }
        });
        this.viewer.getControl().setMenu(menu.createContextMenu(this.viewer.getControl()));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ICodeSelectorTarget target;
                IStructuredSelection selection = CodeElementStatisticsComposite.this.viewer.getStructuredSelection();
                if (selection != null && !selection.isEmpty() && (target = CodeSelectorHandler.getInstance().getCodeSelectorTarget()) != null) {
                    for (Object selected : selection.toList()) {
                        target.codeSelected(selected);
                    }
                }
            }
        });
        new GenericObjectDragSource((StructuredViewer)this.viewer);
    }

    public void setTitle(String title) {
        this.title.setText(title);
        this.layout(true, true);
    }

    public void setContact(IContact contact) {
        this.contact = contact;
        if (contact != null) {
            this.viewer.setInput((Object)CodeElementServiceHolder.getStatistics((String)this.elexisClassName, (IContact)contact));
        } else {
            this.viewer.setInput(Collections.emptyList());
        }
    }

    private class ClearStatisticAction
    extends Action {
        private ClearStatisticAction() {
        }

        public String getText() {
            return Messages.CodeSelectorFactory_resetStatistic;
        }

        public void run() {
            CodeElementServiceHolder.clearStatistics((String)CodeElementStatisticsComposite.this.elexisClassName, (IContact)CodeElementStatisticsComposite.this.contact);
            CodeElementStatisticsComposite.this.viewer.setInput((Object)CodeElementServiceHolder.getStatistics((String)CodeElementStatisticsComposite.this.elexisClassName, (IContact)CodeElementStatisticsComposite.this.contact));
        }
    }
}

