/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.data.Brief;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class TemplatePrintView
extends ViewPart {
    private static final String KEY_TEXT = "text";
    private static final String KEY_BRIEF = "brief";
    public static final String ID = "ch.elexis.views.TemplatePrintView";
    CTabFolder ctab;
    private int existing;
    private TextContainer text;

    public void createPartControl(Composite parent) {
        this.ctab = new CTabFolder(parent, 1024);
        this.ctab.setLayout((Layout)new FillLayout());
    }

    CTabItem addItem(String template, String title, Kontakt adressat) {
        CTabItem ret = new CTabItem(this.ctab, 0);
        this.text = new TextContainer(this.getViewSite());
        ret.setControl((Control)this.text.getPlugin().createContainer((Composite)this.ctab, new ITextPlugin.ICallback(){

            @Override
            public void save() {
            }

            @Override
            public boolean saveAs() {
                return false;
            }
        }));
        Brief actBrief = this.text.createFromTemplateName(Konsultation.getAktuelleKons(), template, "Allg.", adressat, title);
        ret.setData(KEY_BRIEF, (Object)actBrief);
        ret.setData(KEY_TEXT, (Object)this.text);
        ret.setText(title);
        return ret;
    }

    public void setFocus() {
    }

    public void dispose() {
        this.clearItems();
        super.dispose();
    }

    public void clearItems() {
        int i = 0;
        while (i < this.ctab.getItems().length) {
            this.useItem(i, null, null);
            ++i;
        }
    }

    public void useItem(int idx, String template, Kontakt adressat) {
        CTabItem item = this.ctab.getItem(idx);
        if (!item.isDisposed()) {
            Brief brief = (Brief)item.getData(KEY_BRIEF);
            TextContainer text = (TextContainer)item.getData(KEY_TEXT);
            text.saveBrief(brief, "Allg.");
            String betreff = brief.getBetreff();
            brief.delete();
            if (template != null) {
                Brief actBrief = text.createFromTemplateName(Konsultation.getAktuelleKons(), template, "Allg.", adressat, betreff);
                item.setData(KEY_BRIEF, (Object)actBrief);
            }
        }
    }

    public void doShow(Patient pat, String templateName) {
        this.existing = this.ctab.getItems().length;
        if (--this.existing < 0) {
            this.addItem(templateName, templateName, (Kontakt)pat);
        } else {
            this.ctab.getItem(0);
            this.useItem(0, templateName, (Kontakt)pat);
        }
    }

    public boolean doPrint(Patient pat, String templateName, String printer, String tray, IProgressMonitor monitor) {
        CTabItem ct;
        monitor.subTask(pat.getLabel());
        this.existing = this.ctab.getItems().length;
        if (--this.existing < 0) {
            ct = this.addItem(templateName, templateName, (Kontakt)pat);
        } else {
            ct = this.ctab.getItem(0);
            this.useItem(0, templateName, (Kontakt)pat);
        }
        TextContainer text = (TextContainer)ct.getData(KEY_TEXT);
        text.getPlugin().setFont("Serif", 0, 9.0f);
        if (!text.getPlugin().print(printer, tray, false)) {
            return false;
        }
        monitor.worked(1);
        return true;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

