/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.ObjectFilterRegistry;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.FallDetailView;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.provider.FaelleContentProvider;
import ch.elexis.core.ui.views.provider.FaelleLabelProvider;
import ch.elexis.data.Konsultation;
import ch.rgw.tools.ExHandler;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class FaelleView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.schoebufaelle";
    TableViewer tv;
    ViewMenus menus;
    private IAction konsFilterAction;
    private IAction filterClosedAction;
    private final FallKonsFilter filter = new FallKonsFilter();
    private IPatient actPatient;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private ICoverage actCoverage;

    @Inject
    void activePatient(@Optional IPatient patient) {
        Display.getDefault().asyncExec(() -> this.handleEventPatient(patient));
    }

    @Optional
    @Inject
    void lockedPatient(@UIEventTopic(value="info/elexis/locking/aquired") IPatient patient) {
        this.handleEventPatient(patient);
    }

    @Optional
    @Inject
    void unlockedPatient(@UIEventTopic(value="info/elexis/locking/released") IPatient patient) {
        this.handleEventPatient(patient);
    }

    private void handleEventPatient(IPatient patient) {
        if (patient != null && CoreUiUtil.isActiveControl((Control)this.tv.getControl()) && this.actPatient != patient) {
            this.actPatient = patient;
            this.tv.refresh(true);
            this.actCoverage = ContextServiceHolder.get().getRootContext().getTyped(ICoverage.class).orElse(null);
            if (this.actCoverage != null) {
                this.tv.setSelection((ISelection)new StructuredSelection((Object)this.actCoverage));
            }
        }
    }

    @Optional
    @Inject
    void compatitbility(@UIEventTopic(value="info/elexis/po/compatibility/*") Object object) {
        if (object instanceof ICoverage || object instanceof Class && object.equals(ICoverage.class)) {
            if (this.actPatient != null) {
                if (object instanceof ICoverage) {
                    CoreModelServiceHolder.get().refresh((Identifiable)((ICoverage)object), true);
                }
                CoreModelServiceHolder.get().refresh((Identifiable)this.actPatient, true);
            }
            this.refreshTableViewer();
        }
    }

    @Optional
    @Inject
    void createCoverage(@UIEventTopic(value="info/elexis/model/create") ICoverage iCoverage) {
        this.refreshTableViewer();
    }

    @Optional
    @Inject
    void updateCoverage(@UIEventTopic(value="info/elexis/model/update") ICoverage iCoverage) {
        CoreModelServiceHolder.get().refresh((Identifiable)this.actPatient);
        this.refreshTableViewer();
    }

    @Optional
    @Inject
    void deleteCoverage(@UIEventTopic(value="info/elexis/model/delete") ICoverage iCoverage) {
        this.refreshTableViewer();
    }

    @Optional
    @Inject
    void reloadCoverage(@UIEventTopic(value="info/elexis/model/reload") Class<?> iCoverage) {
        if (ICoverage.class.equals(iCoverage)) {
            this.refreshTableViewer();
        }
    }

    @Inject
    void activeCoverage(@Optional ICoverage iCoverage) {
        Display.getDefault().syncExec(() -> {
            if (this.tv != null && CoreUiUtil.isActiveControl((Control)this.tv.getControl())) {
                this.tv.refresh(true);
                this.actCoverage = iCoverage;
                if (this.actCoverage != null) {
                    this.tv.setSelection((ISelection)new StructuredSelection((Object)this.actCoverage));
                }
                if (this.konsFilterAction.isChecked()) {
                    this.filter.setFall(iCoverage);
                }
            }
        });
    }

    private void refreshTableViewer() {
        if (this.tv != null && CoreUiUtil.isActiveControl((Control)this.tv.getControl())) {
            this.tv.refresh(true);
        }
    }

    public FaelleView() {
        this.makeActions();
    }

    public void createPartControl(Composite parent) {
        this.setPartName(Messages.Core_Cases);
        parent.setLayout((Layout)new GridLayout());
        this.tv = new TableViewer(parent, 770);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tv.setContentProvider((IContentProvider)new FaelleContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new FaelleLabelProvider());
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ICoverage selectedCoverage;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty() && (selectedCoverage = (ICoverage)((StructuredSelection)selection).getFirstElement()) != null && !selectedCoverage.equals(FaelleView.this.actCoverage)) {
                    ContextServiceHolder.get().getRootContext().setNamed("elexiseventdispatcher.selection.fallback", (Object)selectedCoverage);
                }
            }
        });
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(GlobalActions.neuerFallAction, this.konsFilterAction, this.filterClosedAction);
        this.menus.createViewerContextMenu((StructuredViewer)this.tv, new IAction[]{GlobalActions.openFallaction, GlobalActions.closeFallAction, null, GlobalActions.delFallAction, GlobalActions.reopenFallAction, GlobalActions.makeBillAction});
        this.tv.setInput((Object)this.getViewSite());
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    FallDetailView fallDetailView = (FallDetailView)FaelleView.this.getSite().getPage().showView("ch.elexis.FallDetailView");
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setFocus() {
        this.tv.getControl().setFocus();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.handleEventPatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private void makeActions() {
        this.konsFilterAction = new Action(Messages.FaelleView_FilterConsultations, 2){
            {
                this.setToolTipText(Messages.FaelleView_ShowOnlyConsOfThisCase);
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
            }

            public void run() {
                if (!this.isChecked()) {
                    ObjectFilterRegistry.getInstance().unregisterObjectFilter(Konsultation.class, FaelleView.this.filter);
                } else {
                    ObjectFilterRegistry.getInstance().registerObjectFilter(Konsultation.class, FaelleView.this.filter);
                    FaelleView.this.filter.setFall(ContextServiceHolder.get().getRootContext().getTyped(ICoverage.class).orElse(null));
                }
            }
        };
        this.filterClosedAction = new Action("", 2){
            private ViewerFilter closedFilter;
            {
                this.setToolTipText(Messages.FaelleView_ShowOnlyOpenCase);
                this.setImageDescriptor(Images.IMG_DOCUMENT_WRITE.getImageDescriptor());
                this.closedFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof ICoverage) {
                            ICoverage fall = (ICoverage)element;
                            return fall.isOpen();
                        }
                        return false;
                    }
                };
            }

            public void run() {
                if (!this.isChecked()) {
                    FaelleView.this.tv.removeFilter(this.closedFilter);
                } else {
                    FaelleView.this.tv.addFilter(this.closedFilter);
                }
            }
        };
    }

    class FallKonsFilter
    implements ObjectFilterRegistry.IObjectFilterProvider,
    IFilter {
        ICoverage mine;
        boolean bDaempfung;

        FallKonsFilter() {
        }

        void setFall(ICoverage fall) {
            this.mine = fall;
            ContextServiceHolder.get().postEvent("info/elexis/model/reload", IEncounter.class);
        }

        @Override
        public void activate() {
            this.bDaempfung = true;
            FaelleView.this.konsFilterAction.setChecked(true);
            this.bDaempfung = false;
        }

        @Override
        public void changed() {
        }

        @Override
        public void deactivate() {
            this.bDaempfung = true;
            FaelleView.this.konsFilterAction.setChecked(false);
            this.bDaempfung = false;
        }

        @Override
        public IFilter getFilter() {
            return this;
        }

        @Override
        public String getId() {
            return "ch.elexis.FallFilter";
        }

        public boolean select(Object toTest) {
            IEncounter k;
            if (this.mine == null) {
                return true;
            }
            return toTest instanceof IEncounter && (k = (IEncounter)toTest).getCoverage().equals(this.mine);
        }
    }
}

