/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WidgetFactory {
    private Composite parent = null;
    private ScrolledForm form = null;
    private FormToolkit tk = null;

    public static Label createLabel(Composite parent, String Text2) {
        Label ret = new Label(parent, 0);
        ret.setText(Text2);
        return ret;
    }

    public WidgetFactory(Composite parent) {
        this.parent = parent;
    }

    public Button createPushButton(String Text2) {
        Button ret = new Button(this.parent, 8);
        ret.setText(Text2);
        return ret;
    }

    public Button createCheckbox(String Text2) {
        Button ret = new Button(this.parent, 32);
        if (Text2 != null) {
            ret.setText(Text2);
        }
        return ret;
    }

    public Label createLabel(String Text2) {
        Label ret = new Label(this.parent, 0);
        ret.setText(Text2);
        return ret;
    }

    public Text createText(String pre) {
        Text inp = new Text(this.parent, 2048);
        inp.setText(pre);
        return inp;
    }

    public void setParent(Composite parent) {
        this.parent = parent;
    }

    public void createForm(boolean withBorders) {
        if (this.tk == null) {
            this.tk = new FormToolkit(this.parent.getDisplay());
        }
        if (withBorders) {
            this.tk.setBorderStyle(2048);
        }
        this.form = this.tk.createScrolledForm(this.parent);
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public Composite getBody() {
        return this.form.getBody();
    }

    public FormToolkit getToolkit() {
        return this.tk;
    }

    public void setToolkit(FormToolkit tk) {
        this.tk = tk;
    }

    public ExpandableComposite createExpandableComposite(Control client, String Text2) {
        ExpandableComposite ret = this.tk.createExpandableComposite(this.form.getBody(), 2);
        ret.setText(Text2);
        client.setParent((Composite)ret);
        ret.setClient(client);
        ret.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                WidgetFactory.this.form.reflow(true);
            }
        });
        return ret;
    }

    public static ExpandableComposite createExpandableComposite(FormToolkit t, final ScrolledForm f, String text) {
        ExpandableComposite ret = t.createExpandableComposite(f.getBody(), 2);
        ret.setText(text);
        ret.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                f.reflow(true);
            }
        });
        return ret;
    }

    public Label createFormLabel(String text) {
        return this.tk.createLabel(this.form.getBody(), text, 64);
    }

    public Text createFormText(String predef, Object align) {
        Text ret = this.tk.createText(this.form.getBody(), predef);
        if (align != null) {
            ret.setLayoutData(align);
        }
        return ret;
    }

    public Text createFormTextField(String predef) {
        Text ret = this.tk.createText(this.form.getBody(), predef, 66);
        return ret;
    }

    public Button createFormButton(String Text2) {
        Button ret = this.tk.createButton(this.form.getBody(), Text2, 8);
        return ret;
    }

    public Hyperlink createHyperlink(String text, IHyperlinkListener lis) {
        Hyperlink ret = this.tk.createHyperlink(this.form.getBody(), text, 64);
        ret.addHyperlinkListener(lis);
        return ret;
    }

    public Composite createFormSeparator() {
        Composite ret = this.tk.createCompositeSeparator(this.form.getBody());
        return ret;
    }

    public Composite createFormComposite(int style) {
        Composite ret = this.tk.createComposite(this.form.getBody(), style);
        return ret;
    }
}

