/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.views.TemplatePrintView;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class TemplateDrucker {
    TemplatePrintView tpw;
    IWorkbenchPage page;
    Patient patient;
    String template;
    String printer;
    String tray;

    public TemplateDrucker(String template, String printer, String tray) {
        this.template = template;
        this.printer = null;
        this.tray = null;
        if (!StringTool.isNothing((Object)printer)) {
            this.printer = printer;
        }
        if (!StringTool.isNothing((Object)tray)) {
            this.tray = tray;
        }
    }

    public void doPrint(Patient pat) {
        this.patient = pat;
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            this.tpw = (TemplatePrintView)this.page.showView("ch.elexis.views.TemplatePrintView");
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(String.valueOf(Messages.TemplateDrucker_printing) + TemplateDrucker.this.template + "...", 1);
                    Patient actPatient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                    if (!TemplateDrucker.this.tpw.doPrint(actPatient, TemplateDrucker.this.template, TemplateDrucker.this.printer, TemplateDrucker.this.tray, monitor)) {
                        Status status = new Status(4, "ch.elexis", 4, Messages.Core_Error_while_printing, null);
                        ErrorDialog.openError(null, (String)Messages.Core_Error_while_printing, (String)(String.valueOf(Messages.TemplateDrucker_docname) + TemplateDrucker.this.template + Messages.Core_Backslash_could_not_be_printed), (IStatus)status);
                    }
                    monitor.done();
                }
            }, null);
            this.page.hideView((IViewPart)this.tpw);
        }
        catch (Exception ex) {
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, String.valueOf(Messages.Core_Error_while_printing) + ": " + Messages.TemplateDrucker_couldntOpen, ex);
            StatusManager.getManager().handle((IStatus)status);
        }
    }
}

