/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class SqlWithUiRunner {
    static Log log = Log.get("SqlWithUiRunner");
    private List<String> sqlStrings = new ArrayList<String>();
    private List<UpdateDbSql> sql;
    private String pluginId;

    public SqlWithUiRunner(String[] sql, String pluginId) {
        int i = 0;
        while (i < sql.length) {
            String[] parts;
            String sqlString = sql[i];
            sqlString = sqlString.replaceAll("\r", "");
            String[] stringArray = parts = sqlString.split("\n\n");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                this.sqlStrings.add(part);
                ++n2;
            }
            ++i;
        }
        this.pluginId = pluginId;
    }

    public boolean runSql() {
        this.sql = new ArrayList<UpdateDbSql>();
        for (String sqlString : this.sqlStrings) {
            this.sql.add(new UpdateDbSql(sqlString));
        }
        if (this.isDisplayAvailable()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell parent = null;
                    boolean isDummyShell = false;
                    try {
                        parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    }
                    catch (IllegalStateException e) {
                        parent = new Shell(Display.getDefault());
                        isDummyShell = true;
                    }
                    catch (NullPointerException e) {
                        parent = new Shell(Display.getDefault());
                        isDummyShell = true;
                    }
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(parent);
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                monitor.beginTask("Running DB Script", (this).SqlWithUiRunner.this.sql.size());
                                for (UpdateDbSql update : (this).SqlWithUiRunner.this.sql) {
                                    monitor.subTask(update.getSql());
                                    update.run();
                                    monitor.worked(1);
                                }
                                monitor.done();
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (isDummyShell) {
                        parent.close();
                    }
                }
            });
        } else {
            for (UpdateDbSql update : this.sql) {
                update.run();
            }
        }
        for (UpdateDbSql update : this.sql) {
            if (update.getStatus() != SqlStatus.FAIL) continue;
            return false;
        }
        return true;
    }

    protected boolean isDisplayAvailable() {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return Display.getDefault() != null;
    }

    static enum SqlStatus {
        NONE,
        EXECUTE,
        SUCCESS,
        FAIL;

    }

    protected class UpdateDbSql
    implements Runnable {
        private String sql;
        private SqlStatus status;
        private boolean optional;

        protected UpdateDbSql(String sql) {
            if (sql.startsWith("OPTIONAL:")) {
                this.optional = true;
                sql = sql.substring("OPTIONAL:".length());
            } else {
                this.optional = false;
            }
            this.sql = sql;
            this.status = SqlStatus.NONE;
        }

        @Override
        public void run() {
            JdbcLink link = null;
            JdbcLink.Stm statement = null;
            try {
                try {
                    String sqlString;
                    link = PersistentObject.getConnection();
                    statement = link.getStatement();
                    this.setStatus(SqlStatus.EXECUTE);
                    ByteArrayInputStream scriptStream = new ByteArrayInputStream(this.sql.getBytes("UTF-8"));
                    while ((sqlString = JdbcLink.readStatement((InputStream)scriptStream)) != null) {
                        try {
                            statement.exec(link.translateFlavor(sqlString));
                        }
                        catch (JdbcLinkException e) {
                            if (this.optional) {
                                log.log(e, "Warning " + e.getMessage() + " during db update", 3);
                                continue;
                            }
                            this.setStatus(SqlStatus.FAIL);
                            log.log(e, "Error " + e.getMessage() + " during db update", 2);
                            try {
                                StatusManager.getManager().handle((IStatus)new ElexisStatus(4, SqlWithUiRunner.this.pluginId, 0, "Error " + e.getMessage() + " during db update", (Exception)((Object)e)));
                            }
                            catch (AssertionFailedException assertionFailedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.setStatus(SqlStatus.FAIL);
                    try {
                        StatusManager.getManager().handle((IStatus)new ElexisStatus(4, SqlWithUiRunner.this.pluginId, 0, "Error " + e.getMessage() + " during db update", (Exception)e));
                    }
                    catch (AssertionFailedException appnotinit) {
                        log.log(e, "Error " + e.getMessage() + " during db update", 2);
                    }
                    if (link != null && statement != null) {
                        link.releaseStatement(statement);
                    }
                    return;
                }
            }
            finally {
                if (link != null && statement != null) {
                    link.releaseStatement(statement);
                }
            }
            if (this.getStatus() == SqlStatus.EXECUTE) {
                this.setStatus(SqlStatus.SUCCESS);
            }
        }

        public void setStatus(SqlStatus status) {
            this.status = status;
        }

        public SqlStatus getStatus() {
            return this.status;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

