/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.data.PersistentObject;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public class PersistentObjectDragSource
implements DragSourceListener {
    ISelectionRenderer renderer;
    Control dragSource;
    List<PersistentObject> selection;
    protected static PersistentObject draggedObject;
    Transfer myTransfer = TextTransfer.getInstance();

    public PersistentObjectDragSource(final StructuredViewer v) {
        this.dragSource = v.getControl();
        this.renderer = new ISelectionRenderer(){

            @Override
            public List<PersistentObject> getSelection() {
                IStructuredSelection sel = (IStructuredSelection)v.getSelection();
                return sel.toList();
            }
        };
        this.setup();
    }

    public PersistentObjectDragSource(Control source, ISelectionRenderer renderer) {
        this.renderer = renderer;
        this.dragSource = source;
        this.setup();
    }

    private void setup() {
        DragSource mine = new DragSource(this.dragSource, 1);
        mine.setTransfer(new Transfer[]{this.myTransfer});
        mine.addDragListener((DragSourceListener)this);
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        StringBuilder sb = new StringBuilder();
        for (PersistentObject s : this.selection) {
            sb.append(s.storeToString()).append(",");
        }
        event.data = sb.toString().replace(",$", "");
    }

    public void dragStart(DragSourceEvent event) {
        this.selection = this.renderer.getSelection();
        event.doit = this.selection == null || this.selection.isEmpty() ? false : this.selection.get(0).isDragOK();
        if (event.doit) {
            draggedObject = this.selection.get(0);
        }
    }

    public static void setDraggedObject(PersistentObject persistentObject) {
        draggedObject = persistentObject;
    }

    public static PersistentObject getDraggedObject() {
        return draggedObject;
    }

    public static interface ISelectionRenderer {
        public List<PersistentObject> getSelection();
    }
}

