/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.text.EnhancedTextField;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransparentTextModificationLockHandler
implements VerifyKeyListener {
    private static final long LOCK_WINDOW_SECS = 60L;
    private Logger logger;
    private ScheduledExecutorService executor;
    private EnhancedTextField enhancedTextField;

    public TransparentTextModificationLockHandler(EnhancedTextField enhancedTextField) {
        this.enhancedTextField = enhancedTextField;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void verifyKey(VerifyEvent event) {
        if (0x1000003 == event.keyCode || 0x1000004 == event.keyCode || 0x1000001 == event.keyCode || 0x1000002 == event.keyCode) {
            event.doit = true;
            return;
        }
        IEncounter encounter = this.enhancedTextField.getEncounter();
        if (!this.enhancedTextField.isUnlocked() && encounter != null && !LocalLockServiceHolder.get().isLocked((Object)encounter)) {
            BusyIndicator.showWhile((Display)this.enhancedTextField.getDisplay(), () -> {
                LockResponse lockResponse = LocalLockServiceHolder.get().acquireLockBlocking((Object)encounter, 1, (IProgressMonitor)new NullProgressMonitor());
                if (!lockResponse.isOk()) {
                    verifyEvent.doit = false;
                    LockResponseHelper.showInfo(lockResponse, encounter, this.logger);
                    return;
                }
                this.enhancedTextField.setEditable(true);
                this.executor.schedule(() -> {
                    LockResponse releaseLock;
                    if (LocalLockServiceHolder.get().isLocked((Object)encounter) && !(releaseLock = LocalLockServiceHolder.get().releaseLock(lockResponse.getLockInfo())).isOk()) {
                        LockResponseHelper.showInfo(releaseLock, encounter, this.logger);
                    }
                }, 60L, TimeUnit.SECONDS);
            });
        }
        event.doit = true;
    }
}

