/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.services.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IUser;
import ch.elexis.core.ui.ILoginNews;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import java.util.List;
import java.util.Optional;
import javax.security.auth.login.LoginException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.LoggerFactory;

public class LocalUserLoginDialog
extends TitleAreaDialog {
    private Text usr;
    private Text pwd;
    private boolean hasUsers;
    private IUser user;
    private IElexisEnvironmentService elexisEnvironmentService;

    public LocalUserLoginDialog(Shell parentShell, IElexisEnvironmentService elexisEnvironmentService) {
        super(parentShell);
        Query qbe = new Query(Anwender.class);
        List list = qbe.execute();
        this.hasUsers = list.size() > 1;
        this.elexisEnvironmentService = elexisEnvironmentService;
    }

    protected Control createDialogArea(Composite parent) {
        List newsModules;
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout(2, false));
        Label lu = new Label(ret, 0);
        lu.setText(Messages.Benutzer_Name);
        this.usr = new Text(ret, 2048);
        this.usr.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.Core_Password);
        this.pwd = new Text(ret, 0x400800);
        this.pwd.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        if (!this.hasUsers) {
            this.usr.setText("Administrator");
            this.pwd.setText("admin");
        }
        if ((newsModules = Extensions.getClasses((String)"ch.elexis.core.ui.LoginNews", (String)"class")).size() > 0) {
            Composite cNews = new Composite(ret, 0);
            cNews.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, true));
            cNews.setLayout((Layout)new GridLayout());
            for (ILoginNews lm : newsModules) {
                try {
                    Composite comp = lm.getComposite(cNews);
                    comp.setLayoutData((Object)SWTHelper.getFillGridData());
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        }
        return ret;
    }

    protected void okPressed() {
        String username = this.usr.getText();
        IUser _user = null;
        Optional dbUser = CoreModelServiceHolder.get().load(username, IUser.class);
        if (dbUser.isPresent()) {
            _user = ((IUser)dbUser.get()).login(username, this.pwd.getTextChars());
        }
        if (_user != null && _user.isActive()) {
            Anwender anwender = Anwender.load((String)_user.getAssignedContact().getId());
            if (anwender != null) {
                if (anwender.isValid()) {
                    if (anwender.istAnwender()) {
                        this.user = _user;
                        if (this.elexisEnvironmentService != null) {
                            this.elexisEnvironmentService.loadAccessToken(username, this.pwd.getTextChars());
                        }
                        super.okPressed();
                        return;
                    }
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("username: {}", (Object)username, (Object)new LoginException("anwender is not a istAnwender"));
                } else {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("username: {}", (Object)username, (Object)new LoginException("anwender is invalid or deleted"));
                }
            } else {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("username: {}", (Object)username, (Object)new LoginException("anwender is null"));
            }
        }
        this.setMessage(Messages.LoginDialog_4, 3);
    }

    protected void cancelPressed() {
        ContextServiceHolder.get().setActiveUser(null);
        CoreHub.actMandant = null;
        super.cancelPressed();
        if (GlobalActions.exitAction != null) {
            GlobalActions.exitAction.run();
        }
    }

    public void create() {
        super.create();
        this.getButton(0).setText(Messages.Core_Login);
        this.getButton(1).setText(Messages.LoginDialog_terminate);
    }

    public IUser getUser() {
        return this.user;
    }
}

