/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences.inputs;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.preferences.inputs.Messages;
import ch.elexis.core.ui.util.DecoratedString;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DecoratedStringChooser
extends Composite {
    public DecoratedStringChooser(Composite parent, final String prefix, DecoratedString[] strings) {
        super(parent, 2048);
        int num = strings.length;
        int typRows = (int)Math.sqrt(num);
        int typCols = typRows + (num - typRows * typRows);
        if (typCols < 4) {
            typCols = 4;
        }
        this.setLayout((Layout)new GridLayout(typCols, true));
        Label expl = new Label((Composite)this, 64);
        expl.setText(Messages.DecoratedStringChooser_howToChange);
        expl.setLayoutData((Object)SWTHelper.getFillGridData(typCols, false, 1, false));
        int i = 0;
        while (i < num) {
            Label lab = new Label((Composite)this, 0);
            lab.setText(strings[i].getText());
            lab.setData((Object)strings[i].getValue());
            String coldesc = strings[i].getValue() != null ? ConfigServiceHolder.getUser((String)(String.valueOf(prefix) + "/" + strings[i].getValue()), (String)"FFFFFF") : ConfigServiceHolder.getUser((String)(String.valueOf(prefix) + "/" + strings[i].getText()), (String)"FFFFFF");
            Color background = UiDesk.getColorFromRGB(coldesc);
            lab.setBackground(background);
            GridData gd = new GridData(1808);
            lab.setLayoutData((Object)gd);
            lab.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    ColorDialog cd = new ColorDialog(DecoratedStringChooser.this.getShell());
                    Label l = (Label)e.getSource();
                    RGB selected = cd.open();
                    if (selected != null) {
                        String symbolic = UiDesk.createColor(selected);
                        l.setBackground(UiDesk.getColorFromRGB(symbolic));
                        if (l.getData() != null) {
                            ConfigServiceHolder.setUser((String)(String.valueOf(prefix) + "/" + (String)l.getData()), (String)symbolic);
                        } else {
                            ConfigServiceHolder.setUser((String)(String.valueOf(prefix) + "/" + l.getText()), (String)symbolic);
                        }
                    }
                }
            });
            ++i;
        }
    }
}

