/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.server.ILockService;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockStatusDialog;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=info/elexis/model/reload"})
public class LockStatusDialogHandler
extends AbstractHandler
implements IElementUpdater,
EventHandler {
    public static final String COMMAND_ID = "ch.elexis.core.ui.locks.LockStatusDialog";
    private ImageDescriptor localIcon;
    private ImageDescriptor remoteIcon;
    private ImageDescriptor standaloneIcon;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LockStatusDialog lockStatusDialog = new LockStatusDialog(Hub.getActiveShell());
        lockStatusDialog.open();
        return null;
    }

    private void prepareIcons() {
        this.localIcon = Images.IMG_LOCK_CLOSED_YELLOW.getURLImageDescriptor();
        this.remoteIcon = Images.IMG_LOCK_CLOSED_GREEN.getURLImageDescriptor();
        this.standaloneIcon = Images.IMG_LOCK_CLOSED_GREY.getURLImageDescriptor();
    }

    public void updateElement(UIElement element, Map parameters) {
        IElexisServerService.ConnectionStatus connectionStatus;
        if (this.localIcon == null || this.remoteIcon == null || this.standaloneIcon == null) {
            this.prepareIcons();
        }
        if ((connectionStatus = ElexisServerServiceHolder.get().getConnectionStatus()) == IElexisServerService.ConnectionStatus.STANDALONE) {
            element.setIcon(this.standaloneIcon);
        } else if (connectionStatus == IElexisServerService.ConnectionStatus.LOCAL) {
            element.setIcon(this.localIcon);
        } else if (connectionStatus == IElexisServerService.ConnectionStatus.REMOTE) {
            element.setIcon(this.remoteIcon);
        }
    }

    public void handleEvent(Event event) {
        Object property = event.getProperty("org.eclipse.e4.data");
        if (Objects.equals(property, ILockService.class) && PlatformUI.isWorkbenchRunning()) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            commandService.refreshElements(COMMAND_ID, null);
        }
    }
}

