/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockResponseHelper;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireLockUi {
    private static Logger logger = LoggerFactory.getLogger(AcquireLockUi.class);

    public static void aquireAndRun(final IPersistentObject lockPo, final ILockHandler lockhandler) {
        Display display = Display.getDefault();
        final LockResponse result = LocalLockServiceHolder.get().acquireLock((Object)lockPo);
        if (result.isOk()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    lockhandler.lockAcquired();
                }
            });
            LocalLockServiceHolder.get().releaseLock((Object)lockPo);
        } else {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    lockhandler.lockFailed();
                    LockResponseHelper.showInfo(result, lockPo, logger);
                }
            });
        }
    }

    public static void aquireAndRun(final Identifiable identifiable, final ILockHandler lockhandler) {
        Display display = Display.getDefault();
        final LockResponse result = LocalLockServiceHolder.get().acquireLock((Object)identifiable);
        if (result.isOk()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    lockhandler.lockAcquired();
                }
            });
            LocalLockServiceHolder.get().releaseLock((Object)identifiable);
        } else {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    lockhandler.lockFailed();
                    LockResponseHelper.showInfo(result, identifiable, logger);
                }
            });
        }
    }
}

