/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.extension.ICoreOperationAdvisor;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.ILoginContributor;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.dialogs.ErsterMandantDialog;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.SqlWithUiRunner;
import ch.elexis.core.ui.wizards.DBConnectWizard;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Anwender;
import java.lang.reflect.InvocationTargetException;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class CoreOperationAdvisor
implements ICoreOperationAdvisor {
    @Reference(target="(id=login.envvars)")
    private ILoginContributor loginEnv;
    @Reference(target="(id=login.dialog)")
    private ILoginContributor loginDialog;
    public String initialPerspectiveString;
    private Logger log = LoggerFactory.getLogger(CoreOperationAdvisor.class);

    public void requestDatabaseConnectionConfiguration() {
        WizardDialog wd = new WizardDialog(UiDesk.getTopShell(), (IWizard)new DBConnectWizard());
        wd.create();
        SWTHelper.center(wd.getShell());
        wd.open();
        CoreHub.localCfg.flush();
    }

    public void requestInitialMandatorConfiguration() {
        Display d = Display.getDefault();
        new ErsterMandantDialog(d.getActiveShell()).open();
    }

    public void adaptForUser() {
        if (CoreHub.getLoggedInContact() != null) {
            this.initialPerspectiveString = CoreHub.localCfg.get(CoreHub.getLoggedInContact() + "/default_perspective", null);
            boolean fixLayoutChecked = ConfigServiceHolder.getUser((String)"perspectives/fix_layout", (boolean)false);
            if (GlobalActions.fixLayoutAction != null) {
                GlobalActions.fixLayoutAction.setChecked(fixLayoutChecked);
            }
        } else if (GlobalActions.fixLayoutAction != null) {
            GlobalActions.fixLayoutAction.setChecked(false);
        }
    }

    public String getInitialPerspective() {
        return this.initialPerspectiveString == null ? "ch.elexis.PatientPerspective" : this.initialPerspectiveString;
    }

    public void openInformation(String title, String message) {
        if (this.isDisplayAvailable() && !CoreUtil.isTestMode()) {
            InfoDialogRunnable runnable = new InfoDialogRunnable(title, message);
            Display.getDefault().syncExec((Runnable)runnable);
            if (!PlatformUI.isWorkbenchRunning()) {
                Display.getDefault().dispose();
            }
            return;
        }
        this.log.error("Could not show info [" + title + "] [" + message + "]");
    }

    public boolean openQuestion(String title, String message) {
        if (this.isDisplayAvailable() && !CoreUtil.isTestMode()) {
            QuestionDialogRunnable runnable = new QuestionDialogRunnable(title, message);
            Display.getDefault().syncExec((Runnable)runnable);
            if (!PlatformUI.isWorkbenchRunning()) {
                Display.getDefault().dispose();
            }
            return runnable.getResult();
        }
        this.log.error("Could not ask question [" + title + "] [" + message + "]");
        return false;
    }

    public boolean performLogin(Object shell) {
        CoreHub.logoffAnwender();
        IUser user = null;
        try {
            user = this.loginEnv.performLogin(shell);
        }
        catch (LoginException le) {
            this.log.warn("Unable to login with loginService [{}]: {} - skipping", new Object[]{this.loginEnv.getClass().getName(), le.getMessage(), le});
        }
        if (user == null) {
            try {
                user = this.loginDialog.performLogin(shell);
            }
            catch (LoginException le) {
                this.log.warn("Unable to login with loginService [{}]: {} - skipping", new Object[]{this.loginDialog.getClass().getName(), le.getMessage(), le});
            }
        }
        if (user != null && user.isActive()) {
            ContextServiceHolder.get().setActiveUser(user);
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)CoreHub.getLoggedInContact(), Anwender.class, 64)});
            CoreOperationAdvisorHolder.get().adaptForUser();
            CoreHub.getLoggedInContact().setInitialMandator();
            CoreHub.heart.resume(true);
            return true;
        }
        return false;
    }

    public boolean performDatabaseUpdate(String[] array, String pluginId) {
        return new SqlWithUiRunner(array, pluginId).runSql();
    }

    public void showProgress(final ch.elexis.core.data.util.IRunnableWithProgress irwp, final String taskName) {
        try {
            if (this.isDisplayAvailable()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getDefault().getActiveShell()){

                            protected void configureShell(Shell shell) {
                                super.configureShell(shell);
                                if (taskName != null) {
                                    shell.setText(taskName);
                                }
                            }
                        };
                        IRunnableWithProgress irpwAdapter = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                irwp.run(monitor);
                            }
                        };
                        try {
                            pmd.run(true, true, irpwAdapter);
                        }
                        catch (InterruptedException | InvocationTargetException e) {
                            CoreOperationAdvisor.this.log.error("Execution error", (Throwable)e);
                        }
                    }
                });
            } else {
                irwp.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.log.error("Execution error", (Throwable)e);
        }
    }

    protected boolean isDisplayAvailable() {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return Display.getDefault() != null;
    }

    private class InfoDialogRunnable
    implements Runnable {
        private String title;
        private String message;

        public InfoDialogRunnable(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)this.title, (String)this.message);
        }
    }

    private class QuestionDialogRunnable
    implements Runnable {
        private String title;
        private String message;
        private boolean result;

        public QuestionDialogRunnable(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            this.result = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)this.title, (String)this.message);
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

