/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.User;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotpDialog
extends TitleAreaDialog {
    protected static Logger log = LoggerFactory.getLogger(TotpDialog.class);
    private Image image;
    private Text text;
    private Label lblVerificationResult;
    private StyledText txtTotpCode;
    private User user;
    private Label lblImage;

    public TotpDialog(Shell parentShell) {
        super(parentShell);
    }

    public TotpDialog(Shell topShell, User user) {
        this(topShell);
        this.user = user;
        this.createOtpQRCodeImage();
    }

    private void createOtpQRCodeImage() {
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Validate one-time password");
        this.setMessage(String.format("Scan and verify One-Time Password QR code for user %s", this.user.getLabel()));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        container.setLayoutData((Object)new GridData(1808));
        Composite compositeCode = new Composite(container, 0);
        compositeCode.setLayoutData((Object)new GridData(0x1000000, 4, true, true, 1, 1));
        GridLayout gl_compositeCode = new GridLayout(1, false);
        gl_compositeCode.marginHeight = 0;
        gl_compositeCode.marginWidth = 0;
        compositeCode.setLayout((Layout)gl_compositeCode);
        this.lblImage = new Label(compositeCode, 0);
        this.lblImage.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.lblImage.setImage(this.image);
        this.txtTotpCode = new StyledText(compositeCode, 0);
        this.txtTotpCode.setBackground(this.getShell().getBackground());
        this.txtTotpCode.setEditable(false);
        this.txtTotpCode.setCaret(null);
        this.txtTotpCode.setLayoutData((Object)new GridData(0x1000000, 4, false, false, 1, 1));
        this.txtTotpCode.setText(this.user.getTotp());
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setBounds(0, 0, 64, 64);
        Label lblEnterCurrentCode = new Label(composite, 64);
        lblEnterCurrentCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblEnterCurrentCode.setText("Scan the QR code with an app like Google Authenticator.\n\nEnter code to verify.");
        this.text = new Text(composite, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String otpToken = TotpDialog.this.text.getText();
                if (otpToken.length() > 5 && StringUtils.isNumeric((CharSequence)otpToken) && TotpDialog.this.user.verifyTotp(otpToken)) {
                    TotpDialog.this.lblVerificationResult.setText("Correct");
                    TotpDialog.this.lblVerificationResult.setForeground(UiDesk.getColor("dunkelgruen"));
                    return;
                }
                TotpDialog.this.lblVerificationResult.setText("Incorrect");
                TotpDialog.this.lblVerificationResult.setForeground(UiDesk.getColor("rot"));
            }
        });
        this.lblVerificationResult = new Label(composite, 0);
        this.lblVerificationResult.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Link lnkResetOtp = new Link(container, 0);
        lnkResetOtp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lnkResetOtp.setText("<a>reset</a> (Invalidates existing)");
        lnkResetOtp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TotpDialog.this.user.resetTotp();
                TotpDialog.this.createOtpQRCodeImage();
                TotpDialog.this.lblImage.setImage(TotpDialog.this.image);
                TotpDialog.this.txtTotpCode.setText(TotpDialog.this.user.getTotp());
            }
        });
        new Label(container, 0);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        this.image.dispose();
        super.okPressed();
    }
}

