/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.Person;
import ch.rgw.tools.StringTool;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class KontaktDetailDialog
extends TitleAreaDialog {
    private static final String LBL_MAIL = Messages.Core_E_Mail;
    private static final String LBL_FAX = Messages.Core_Fax;
    private static final String LBL_PHONE = Messages.KontaktDetailDialog_labelPhone;
    private static final String LBL_PLACE = Messages.Core_City;
    private static final String LBL_ZIP = Messages.Core_Postal_code;
    private static final String LBL_STREET = Messages.Core_Street;
    private static final String LBL_ZUSATZ = Messages.Core_Additional;
    private static final String LBL_SEX = Messages.Sex;
    private static final String LBL_BIRTHDATE = Messages.Core_Enter_Birthdate;
    private static final String LBL_FIRSTNAME = Messages.Core_Firstname;
    private static final String LBL_NAME = Messages.Core_Name;
    Kontakt k;
    LabeledInputField liName;
    LabeledInputField liVorname;
    LabeledInputField liGebDat;
    LabeledInputField liSex;
    LabeledInputField liStrasse;
    LabeledInputField liPlz;
    LabeledInputField liOrt;
    LabeledInputField liTel;
    LabeledInputField liFax;
    LabeledInputField liMail;
    String[] vals;
    int type = 0;
    ButtonAdapter ba = new ButtonAdapter();
    private boolean locked = false;

    public KontaktDetailDialog(Shell parentShell, Kontakt kt) {
        super(parentShell);
        this.k = kt;
    }

    public KontaktDetailDialog(Shell parentShell, String[] v) {
        super(parentShell);
        this.vals = v;
    }

    public KontaktDetailDialog(Shell parentShell, Kontakt kt, boolean locked) {
        this(parentShell, kt);
        this.locked = locked;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(3, true));
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        if (this.k == null) {
            Composite cType = new Composite(ret, 2048);
            cType.setLayoutData((Object)SWTHelper.getFillGridData(3, true, 1, false));
            cType.setLayout((Layout)new FillLayout());
            Button bPerson = new Button(cType, 16);
            bPerson.setText(Messages.Core_Person);
            Button bOrg = new Button(cType, 16);
            bOrg.setText(Messages.Core_Organisation);
            bPerson.addSelectionListener((SelectionListener)this.ba);
            bOrg.addSelectionListener((SelectionListener)this.ba);
            this.liName = SWTHelper.createLabeledField(ret, LBL_NAME, LabeledInputField.Typ.TEXT);
            this.liVorname = SWTHelper.createLabeledField(ret, LBL_FIRSTNAME, LabeledInputField.Typ.TEXT);
            this.liGebDat = SWTHelper.createLabeledField(ret, LBL_BIRTHDATE, LabeledInputField.Typ.TEXT);
            this.liSex = SWTHelper.createLabeledField(ret, LBL_SEX, LabeledInputField.Typ.TEXT);
            if (this.vals != null) {
                this.liName.setText(StringTool.unNull((String)this.vals[0]));
                this.liVorname.setText(StringTool.unNull((String)this.vals[1]));
            }
        } else if (this.k.istPerson()) {
            Person p = Person.load((String)this.k.getId());
            this.liName = SWTHelper.createLabeledField(ret, LBL_NAME, LabeledInputField.Typ.TEXT);
            this.liVorname = SWTHelper.createLabeledField(ret, LBL_FIRSTNAME, LabeledInputField.Typ.TEXT);
            this.liGebDat = SWTHelper.createLabeledField(ret, LBL_BIRTHDATE, LabeledInputField.Typ.TEXT);
            this.liSex = SWTHelper.createLabeledField(ret, LBL_SEX, LabeledInputField.Typ.TEXT);
            this.liName.setText(p.getName());
            this.liVorname.setText(p.getVorname());
            this.liGebDat.setText(p.getGeburtsdatum());
            this.liSex.setText(p.getGeschlecht());
        } else {
            this.liName = SWTHelper.createLabeledField(ret, LBL_NAME, LabeledInputField.Typ.TEXT);
            this.liVorname = SWTHelper.createLabeledField(ret, LBL_ZUSATZ, LabeledInputField.Typ.TEXT);
            this.liName.setText(this.k.get("Bezeichnung1"));
            this.liVorname.setText(this.k.get("Bezeichnung2"));
        }
        this.liStrasse = SWTHelper.createLabeledField(ret, LBL_STREET, LabeledInputField.Typ.TEXT);
        this.liPlz = SWTHelper.createLabeledField(ret, LBL_ZIP, LabeledInputField.Typ.TEXT);
        this.liOrt = SWTHelper.createLabeledField(ret, LBL_PLACE, LabeledInputField.Typ.TEXT);
        this.liTel = SWTHelper.createLabeledField(ret, LBL_PHONE, LabeledInputField.Typ.TEXT);
        this.liFax = SWTHelper.createLabeledField(ret, LBL_FAX, LabeledInputField.Typ.TEXT);
        this.liMail = SWTHelper.createLabeledField(ret, LBL_MAIL, LabeledInputField.Typ.TEXT);
        if (this.k != null) {
            Anschrift an = this.k.getAnschrift();
            this.liStrasse.setText(an.getStrasse());
            this.liPlz.setText(an.getPlz());
            this.liOrt.setText(an.getOrt());
            this.liTel.setText(this.k.get("Telefon1"));
            this.liFax.setText(this.k.get(LBL_FAX));
            this.liMail.setText(this.k.get(LBL_MAIL));
        }
        return ret;
    }

    public void create() {
        Button btnOk;
        super.create();
        this.getShell().setText(Messages.KontaktDetailDialog_showDetails);
        if (this.k != null) {
            this.setTitle(this.k.getLabel());
        } else {
            this.setTitle(Messages.KontaktDetailDialog_newContact);
        }
        this.setMessage(Messages.KontaktDetailDialog_enterData);
        if (this.locked && (btnOk = this.getButton(0)) != null) {
            btnOk.setEnabled(false);
        }
    }

    protected void okPressed() {
        if (this.k == null) {
            if (this.type == 0) {
                SWTHelper.showError(Messages.KontaktDetailDialog_typeOfContact, Messages.KontaktDetailDialog_enterType);
                return;
            }
            this.k = this.type == 1 ? new Person(this.liName.getText(), this.liVorname.getText(), this.liGebDat.getText(), this.liSex.getText()) : new Organisation(this.liName.getText(), this.liVorname.getText());
        } else if (this.k.istPerson()) {
            Person p = Person.load((String)this.k.getId());
            p.set(LBL_NAME, this.liName.getText());
            p.set(LBL_FIRSTNAME, this.liVorname.getText());
            p.set(LBL_BIRTHDATE, this.liGebDat.getText());
            p.set(LBL_SEX, this.liSex.getText());
        } else {
            Organisation o = Organisation.load((String)this.k.getId());
            o.set(LBL_NAME, this.liName.getText());
            o.set(LBL_ZUSATZ, this.liVorname.getText());
        }
        Anschrift an = this.k.getAnschrift();
        an.setStrasse(this.liStrasse.getText());
        an.setPlz(this.liPlz.getText());
        an.setOrt(this.liOrt.getText());
        this.k.setAnschrift(an);
        this.k.set("Telefon1", this.liTel.getText());
        this.k.set(LBL_MAIL, this.liMail.getText());
        super.okPressed();
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (((Button)e.getSource()).getText().equals(Messages.Core_Person)) {
                KontaktDetailDialog.this.type = 1;
                KontaktDetailDialog.this.liGebDat.setEnabled(true);
                KontaktDetailDialog.this.liSex.setEnabled(true);
                KontaktDetailDialog.this.liVorname.setLabel(LBL_FIRSTNAME);
            } else {
                KontaktDetailDialog.this.type = 2;
                KontaktDetailDialog.this.liGebDat.setEnabled(false);
                KontaktDetailDialog.this.liSex.setEnabled(false);
                KontaktDetailDialog.this.liVorname.setLabel(LBL_ZUSATZ);
            }
        }
    }
}

