/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.data.Leistungsblock;
import ch.elexis.data.Query;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class BlockSelektor
extends FilteredItemsSelectionDialog {
    private boolean ignoreErrors;

    public BlockSelektor(Shell shell) {
        super(shell);
        this.setTitle("Block Selektion");
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return ((Leistungsblock)element).getLabel();
            }
        });
    }

    public BlockSelektor(Shell shell, Object data) {
        this(shell);
        if (data instanceof String && data.equals("ignoreErrors")) {
            this.ignoreErrors = true;
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (!this.ignoreErrors) {
            super.updateButtonsEnableState(status);
        }
    }

    protected Control createDialogArea(Composite parent) {
        String oldListLabel = WorkbenchMessages.FilteredItemsSelectionDialog_listLabel;
        this.setMessage("");
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = "";
        Control ret = super.createDialogArea(parent);
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = oldListLabel;
        return ret;
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("blockselector");
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected void okPressed() {
        if (this.ignoreErrors) {
            this.updateStatus(Status.OK_STATUS);
        }
        super.okPressed();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                Leistungsblock block = (Leistungsblock)item;
                return this.matches(block.getLabel());
            }
        };
    }

    protected Comparator<Leistungsblock> getItemsComparator() {
        return new Comparator<Leistungsblock>(){

            @Override
            public int compare(Leistungsblock o1, Leistungsblock o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        List allBlocks = new Query(Leistungsblock.class).execute();
        for (Leistungsblock block : allBlocks) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            contentProvider.add((Object)block, itemsFilter);
        }
    }

    public String getElementName(Object item) {
        Leistungsblock block = (Leistungsblock)item;
        return block.getLabel();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }
}

