/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;
import com.google.common.collect.ImmutableMap;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interaction
extends PersistentObject {
    public static final String TABLENAME = "ch_elexis_interaction";
    public static final String VERSION = "1.0.0";
    public static final String VERSIONID = "VERSION";
    public static final String FLD_ATC1 = "ATC1";
    public static final String FLD_ATC2 = "ATC2";
    public static final String FLD_NAME1 = "NAME1";
    public static final String FLD_NAME2 = "NAME2";
    public static final String FLD_INFO = "INFO";
    public static final String FLD_MECHANISM = "MECHANISM";
    public static final String FLD_EFFECT = "EFFECT";
    public static final String FLD_MEASURES = "MEASURES";
    public static final String FLD_SEVERITY = "SEVERITY";
    public static final String FLD_ABUSE_ID_FOR_VERSION = "NAME1";
    public static final String FLD_ABUSE_ID_FOR_LAST_PARSED = "NAME2";
    public static final String FLD_ABUSE_ID_FOR_SHA = "MECHANISM";
    public static final Map<String, String> Ratings = ImmutableMap.of((Object)"A", (Object)Messages.Interaction_Class_A, (Object)"B", (Object)Messages.Interaction_Class_B, (Object)"C", (Object)Messages.Interaction_Class_C, (Object)"D", (Object)Messages.Interaction_Class_D, (Object)"X", (Object)Messages.Interaction_Class_X);
    public static final Map<String, String> Colors = ImmutableMap.of((Object)"A", (Object)"caff70", (Object)"B", (Object)"ffec8b", (Object)"C", (Object)"ffb90f", (Object)"D", (Object)"ff82ab", (Object)"X", (Object)"ff6a6a");
    private static Logger logger = LoggerFactory.getLogger(Interaction.class);
    private static int notImported = 0;
    private static String hash_from_file = "";
    private static int importerInteractionsCreated = 0;
    private static final String MATRIX_CSV_URL = "https://raw.githubusercontent.com/zdavatz/oddb2xml_files/master/interactions_de_utf8.csv";
    private static final File MATRIX_CSV_LOCAL = new File(CoreHub.getWritableUserDir(), "matrix.csv");
    static final String create = "CREATE TABLE ch_elexis_interaction (ID VARCHAR(25) primary key, lastupdate BIGINT,deleted CHAR(1) default '0',atc1 VARCHAR(8),name1 VARCHAR(128),atc2 VARCHAR(8),name2 VARCHAR(128),info VARCHAR(255),mechanism VARCHAR(255),effect VARCHAR(255),measures VARCHAR(255),severity CHAR(1));CREATE UNIQUE INDEX atc1_atc2 ON ch_elexis_interaction (ATC1,ATC2);INSERT INTO ch_elexis_interaction (ID,NAME1) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        Interaction.addMapping((String)TABLENAME, (String[])new String[]{FLD_ATC1, "NAME1", FLD_ATC2, "NAME2", FLD_INFO, "MECHANISM", FLD_EFFECT, FLD_MEASURES, FLD_SEVERITY});
        if (!Interaction.tableExists((String)TABLENAME)) {
            Interaction.createOrModifyTable((String)create);
        } else {
            Interaction version = Interaction.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get("NAME1"));
            if (vi.isOlder(VERSION)) {
                version.set("NAME1", VERSION);
            }
        }
        if (!ConfigServiceHolder.getUser((String)"anwender/suppressintractioncheck", (boolean)true)) {
            Interaction.importMappingFromCsv();
        }
    }

    public Interaction() {
    }

    Interaction(String atc1, String name1, String atc2, String name2, String info, String mechanism, String effect, String measures, String severity) {
        this.create(null);
        severity = severity.trim();
        if (severity.length() > 1) {
            log.warn("Unable to import {} {} {} {} severity wrong {} {}", new Object[]{atc1, name1, atc2, name2, severity, severity.length()});
            severity = "D";
        }
        if (!this.set(new String[]{FLD_ATC1, "NAME1", FLD_ATC2, "NAME2", FLD_INFO, "MECHANISM", FLD_EFFECT, FLD_MEASURES, FLD_SEVERITY}, new String[]{atc1, name1, atc2, name2, Interaction.limit(info, 255), Interaction.limit(mechanism, 255), Interaction.limit(effect, 255), Interaction.limit(measures, 255), severity})) {
            log.warn("Unable to import {} {} {} {} {}", new Object[]{atc1, name1, atc2, name2, severity});
        }
    }

    private static String limit(String aString, int maxLength) {
        if (aString.length() > maxLength) {
            return aString.substring(0, maxLength);
        }
        return aString;
    }

    protected Interaction(String id) {
        super(id);
    }

    public static Interaction load(String id) {
        return new Interaction(id);
    }

    public static String getMeasures(String ATC_1, String ATC_2) {
        Interaction ia = Interaction.getByATC(ATC_1, ATC_2);
        return ia == null ? " " : ia.get(FLD_MEASURES);
    }

    public static String getEffects(String ATC_1, String ATC_2) {
        Interaction ia = Interaction.getByATC(ATC_1, ATC_2);
        return ia == null ? " " : ia.get(FLD_EFFECT);
    }

    public static String getSeverity(String ATC_1, String ATC_2) {
        Interaction ia = Interaction.getByATC(ATC_1, ATC_2);
        return ia == null ? " " : ia.get(FLD_SEVERITY);
    }

    public String getLabel() {
        return String.format("%s %s - %s %s: %s", this.get(FLD_ATC1), this.get(FLD_ATC2), this.get("NAME1"), this.get("NAME2"), this.get(FLD_SEVERITY));
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Interaction getByContactAndItemName(String contactId, String itemName) {
        Query qbe = new Query(Interaction.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add(FLD_ATC1, "=", contactId);
        qbe.add(FLD_ATC2, "=", itemName);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("Found more then 1 mapping for origin id [%s] - [%s]", contactId, itemName));
        }
        return (Interaction)((Object)res.get(0));
    }

    public static Interaction getByATC(String atc1, String atc2) {
        atc1 = atc1.trim();
        atc2 = atc2.trim();
        Query qbe = new Query(Interaction.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add(FLD_ATC1, "=", atc1);
        qbe.add(FLD_ATC2, "=", atc2);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            logger.warn(String.format("Found [%s] mappings for ATC [%s] and [%s]", res.size(), atc1, atc2));
            logger.info(String.format("Using mapping with item name [%s]", ((Interaction)((Object)res.get(0))).getLabel()));
        }
        return (Interaction)((Object)res.get(0));
    }

    private static void downloadMatrix() {
        try {
            logger.info("Start downloading {}", (Object)MATRIX_CSV_URL);
            FileUtils.copyURLToFile((URL)new URL(MATRIX_CSV_URL), (File)MATRIX_CSV_LOCAL);
            logger.info("Finished downloading to {}", (Object)MATRIX_CSV_LOCAL);
        }
        catch (IOException e) {
            logger.error("Unable to download {} to {}: {}", new Object[]{MATRIX_CSV_URL, MATRIX_CSV_LOCAL, e.getMessage()});
            String info = String.format("Unable to find %s", MATRIX_CSV_URL);
            Status status = new Status(4, "ch.elexis.core.ui", 4, info, null);
            ErrorDialog.openError((Shell)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to download", null, (IStatus)status);
        }
    }

    private static boolean getShaFromFile() {
        Interaction version = Interaction.load(VERSIONID);
        try {
            byte[] b = Files.readAllBytes(MATRIX_CSV_LOCAL.toPath());
            byte[] digest = MessageDigest.getInstance("SHA-256").digest(b);
            hash_from_file = DatatypeConverter.printHexBinary((byte[])digest);
            String sha25_from_db = version.get("MECHANISM");
            logger.info("digest for  '{}' {} {}", new Object[]{MATRIX_CSV_LOCAL, sha25_from_db, hash_from_file});
            return hash_from_file.equalsIgnoreCase(sha25_from_db);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            logger.info("Error calculating digest for  '{}' {}", (Object)MATRIX_CSV_LOCAL, (Object)e.getMessage());
            return false;
        }
    }

    private static void importMappingFromCsv() {
        double last;
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy.D");
        LocalDateTime now = LocalDateTime.now();
        final String today = dtf.format(now);
        double curYearDay = Float.parseFloat(today);
        Interaction version = Interaction.load(VERSIONID);
        String lastParsed = version.get("NAME2");
        double d = last = lastParsed == null || lastParsed.length() == 0 ? 0.0 : (double)Float.parseFloat(lastParsed);
        if (lastParsed != null && lastParsed.length() != 0 && curYearDay - last < 1.0) {
            logger.info("Skip importMappingFromCsv as last '{}' equals today {}", (Object)lastParsed, (Object)today);
            return;
        }
        logger.info("Starting importMappingFromCsv as last '{}' smaller today {}", (Object)lastParsed, (Object)today);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            CSVReader cr;
                            monitor.beginTask(String.format(Messages.VerrDetailDialog_DownloadInteractions, Interaction.MATRIX_CSV_URL), 5);
                            Interaction.getDefaultConnection().exec("DELETE FROM ch_elexis_interaction WHERE ID != 'VERSION';");
                            Interaction.getDefaultConnection().exec("UPDATE ch_elexis_interaction SET NAME2 = '', MECHANISM = '' WHERE ID = 'VERSION';");
                            notImported = 0;
                            importerInteractionsCreated = 0;
                            if (MATRIX_CSV_LOCAL.exists() && Interaction.getShaFromFile()) {
                                monitor.done();
                                return;
                            }
                            Interaction.downloadMatrix();
                            if (!MATRIX_CSV_LOCAL.exists()) {
                                logger.error("Unable to import interactions from missing {} ", (Object)MATRIX_CSV_LOCAL);
                                monitor.done();
                                return;
                            }
                            logger.info("Start importing interactions from {} ", (Object)MATRIX_CSV_LOCAL);
                            try {
                                cr = new CSVReader((Reader)new FileReader(MATRIX_CSV_LOCAL), ',', '\"');
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                            String info = String.format(Messages.VerrDetailDialog_ImportInteractions, MATRIX_CSV_LOCAL.toString());
                            try {
                                String[] line;
                                monitor.beginTask(info, (int)(Files.size(MATRIX_CSV_LOCAL.toPath()) / 600L));
                                cr = new CSVReader((Reader)new FileReader(MATRIX_CSV_LOCAL), ',', '\"');
                                while ((line = cr.readNext()) != null) {
                                    monitor.worked(1);
                                    if (line.length == 9) {
                                        if (line[0].equalsIgnoreCase(Interaction.FLD_ATC1)) continue;
                                        new Interaction(line[0], line[1], line[2], line[3], line[4], line[5], line[6], line[7], line[8]);
                                        ++importerInteractionsCreated;
                                    } else {
                                        ++notImported;
                                        logger.info(String.format("Skipping [%s] ", line.toString()));
                                    }
                                    if (!monitor.isCanceled()) continue;
                                    monitor.done();
                                    return;
                                }
                                Interaction.getShaFromFile();
                                Interaction.getDefaultConnection().exec("UPDATE ch_elexis_interaction SET NAME2 = '" + today + "', " + "MECHANISM" + " = '" + hash_from_file + "' WHERE ID = 'VERSION';");
                                logger.info("Imported {} interactions setting date {} sha {}", new Object[]{importerInteractionsCreated, today, hash_from_file});
                            }
                            catch (IOException e) {
                                info = String.format("Import aborted after %d interactions with %d failures ", importerInteractionsCreated, notImported);
                                logger.error(info);
                                Status status = new Status(4, "ch.elexis.core.ui", 4, info, null);
                                ErrorDialog.openError((Shell)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to import", null, (IStatus)status);
                                monitor.done();
                                return;
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    String info = String.format("Import aborted after %d interactions with %d failures ", importerInteractionsCreated, notImported);
                    logger.error(info);
                    Status status = new Status(4, "ch.elexis.core i", 4, info, null);
                    ErrorDialog.openError((Shell)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to import", null, (IStatus)status);
                    return;
                }
            }
        });
    }
}

