/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.TextTemplatePrintSettingsDialog;
import ch.elexis.core.ui.views.textsystem.TextTemplateView;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class TemplatePrintSettingsCommand
extends AbstractHandler {
    public static String ID = "ch.elexis.core.ui.command.templatePrintSettings";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TextTemplate template = this.getSelectedTextTemplate(event);
        if (template == null) {
            return null;
        }
        String cfgTemplate = template.getCfgTemplateBase();
        String cfgPrinter = CoreHub.localCfg.get(String.valueOf(cfgTemplate) + "/printer", null);
        String cfgTray = CoreHub.localCfg.get(String.valueOf(cfgTemplate) + "/tray", null);
        TextTemplatePrintSettingsDialog ttPrintSettingsDialog = new TextTemplatePrintSettingsDialog(UiDesk.getTopShell(), cfgPrinter, cfgTray);
        if (ttPrintSettingsDialog.open() == 0) {
            template.setPrinter(ttPrintSettingsDialog.getPrinter());
            template.setTray(ttPrintSettingsDialog.getMediaTray());
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TextTemplateView textTemplateView = (TextTemplateView)activePage.findView("ch.elexis.views.textsystem.TextTemplateView");
        textTemplateView.update(template);
        return null;
    }

    private TextTemplate getSelectedTextTemplate(ExecutionEvent event) {
        Object firstElement;
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && !selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof TextTemplate) {
            TextTemplate textTemplate = (TextTemplate)firstElement;
            return textTemplate;
        }
        return null;
    }
}

