/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.Brief;
import ch.elexis.data.Patient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendBriefAsMailHandler
extends AbstractHandler
implements IHandler {
    private static final Logger logger = LoggerFactory.getLogger(SendBriefAsMailHandler.class);
    private File attachmentsFolder;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IDocumentLetter> iDocuments;
        Optional selectedDocument = ContextServiceHolder.get().getTyped(IDocumentLetter.class);
        if (selectedDocument.isPresent() && !(iDocuments = Collections.singletonList((IDocumentLetter)selectedDocument.get())).isEmpty()) {
            ICommandService commandService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
            try {
                String documentsString = AttachmentsUtil.getDocumentsString(iDocuments);
                Command sendMailCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMail");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ch.elexis.core.mail.ui.sendMail.documents", documentsString);
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient != null) {
                    params.put("ch.elexis.core.mail.ui.sendMail.subject", "Patient: " + patient.getLabel());
                }
                ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
                ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
            }
            catch (Exception ex) {
                throw new RuntimeException("ch.elexis.core.mail.ui.sendMail not found", ex);
            }
        }
        return null;
    }

    private Optional<File> getTempFile(Brief brief) {
        File tmpDir = CoreHub.getTempDir();
        this.attachmentsFolder = new File(tmpDir, "_att" + System.currentTimeMillis() + "_");
        this.attachmentsFolder.mkdir();
        File tmpFile = new File(this.attachmentsFolder, String.valueOf(brief.getBetreff()) + "." + brief.getMimeType());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fout = new FileOutputStream(tmpFile);){
                byte[] arr = brief.loadBinary();
                if (arr != null && arr.length > 0) {
                    fout.write(arr);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Fehler", (String)"Brief konnte nicht exportiert werden.");
            logger.error("Could not export Brief.", (Throwable)e);
        }
        if (tmpFile != null && tmpFile.exists()) {
            return Optional.of(tmpFile);
        }
        return Optional.empty();
    }

    private void removeTempAttachments(List<File> attachments) {
        for (File file : attachments) {
            file.delete();
        }
        if (this.attachmentsFolder != null && this.attachmentsFolder.exists()) {
            this.attachmentsFolder.delete();
        }
    }

    private String getAttachmentsString(List<File> attachments) {
        StringBuilder sb = new StringBuilder();
        for (File file : attachments) {
            if (sb.length() > 0) {
                sb.append(":::");
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }
}

