/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.views.rechnung.KonsZumVerrechnenView;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.rgw.tools.Tree;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class KonsZumVerrechnenLinkCommand
extends AbstractHandler {
    public static final String CMD_ID = "ch.elexis.core.command.linkViews";
    private TreeSelectionChangedListener leftSideSelChangeListener;
    private TreeSelectionChangedListener rightSideSelChangeListener;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean alreadyToggled = HandlerUtil.toggleCommandState((Command)event.getCommand());
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        KonsZumVerrechnenView kzvView = (KonsZumVerrechnenView)activePage.findView("ch.elexis.BehandlungenVerrechnenView");
        CommonViewer cv = kzvView.getLeftSide();
        TreeViewer tvSel = kzvView.getRightSide();
        if (alreadyToggled) {
            cv.getViewerWidget().removeSelectionChangedListener((ISelectionChangedListener)this.leftSideSelChangeListener);
            tvSel.removeSelectionChangedListener((ISelectionChangedListener)this.rightSideSelChangeListener);
        } else {
            this.leftSideSelChangeListener = new TreeSelectionChangedListener(tvSel);
            this.rightSideSelChangeListener = new TreeSelectionChangedListener((TreeViewer)cv.getViewerWidget());
            cv.getViewerWidget().addSelectionChangedListener((ISelectionChangedListener)this.leftSideSelChangeListener);
            tvSel.addSelectionChangedListener((ISelectionChangedListener)this.rightSideSelChangeListener);
        }
        return null;
    }

    class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        private TreeViewer treeViewer;

        public TreeSelectionChangedListener(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Tree treeElement = (Tree)selection.getFirstElement();
            if (treeElement != null) {
                Konsultation kons;
                Fall fall;
                Object selObj = treeElement.contents;
                Patient selPatient = null;
                if (selObj instanceof Patient) {
                    selPatient = (Patient)selObj;
                } else if (selObj instanceof Fall) {
                    Fall fall2 = (Fall)selObj;
                    selPatient = fall2.getPatient();
                } else if (selObj instanceof Konsultation && (fall = (kons = (Konsultation)selObj).getFall()) != null && fall.exists()) {
                    selPatient = fall.getPatient();
                }
                if (selPatient != null) {
                    TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem i = treeItemArray[n2];
                        Patient p = (Patient)((Tree)i.getData()).contents;
                        if (p.getId().equals(selPatient.getId())) {
                            this.treeViewer.getTree().setSelection(i);
                        }
                        ++n2;
                    }
                    this.treeViewer.refresh();
                }
            }
        }
    }
}

