/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.PersistentObject;
import java.util.Hashtable;
import org.eclipse.jface.viewers.IFilter;

public class ObjectFilterRegistry {
    private static ObjectFilterRegistry theInstance;
    private final Hashtable<Class<? extends PersistentObject>, IObjectFilterProvider> hash = new Hashtable();

    private ObjectFilterRegistry() {
    }

    public static ObjectFilterRegistry getInstance() {
        if (theInstance == null) {
            theInstance = new ObjectFilterRegistry();
        }
        return theInstance;
    }

    public synchronized void registerObjectFilter(Class<? extends PersistentObject> clazz, IObjectFilterProvider provider) {
        IObjectFilterProvider old = this.hash.get(clazz);
        if (old != null) {
            old.deactivate();
        }
        this.hash.put(clazz, provider);
        provider.activate();
        ElexisEventDispatcher.reload(clazz);
    }

    public void unregisterObjectFilter(Class<? extends PersistentObject> clazz, IObjectFilterProvider provider) {
        this.hash.remove(clazz);
        provider.deactivate();
        ElexisEventDispatcher.reload(clazz);
    }

    public IFilter getFilterFor(Class<? extends PersistentObject> clazz) {
        IObjectFilterProvider prov = this.hash.get(clazz);
        if (prov != null) {
            return prov.getFilter();
        }
        return null;
    }

    public static interface IObjectFilterProvider {
        public void activate();

        public void deactivate();

        public String getId();

        public void changed();

        public IFilter getFilter();
    }
}

