/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Color;

public class CodeSelectorHandler {
    private static CodeSelectorHandler theInstance;
    private ICodeSelectorTarget codeSelectorTarget;

    private CodeSelectorHandler() {
    }

    public static CodeSelectorHandler getInstance() {
        if (theInstance == null) {
            theInstance = new CodeSelectorHandler();
        }
        return theInstance;
    }

    public void setCodeSelectorTarget(ICodeSelectorTarget target) {
        if (this.codeSelectorTarget != null) {
            this.codeSelectorTarget.registered(false);
        }
        this.codeSelectorTarget = target;
        this.codeSelectorTarget.registered(true);
    }

    public void removeCodeSelectorTarget() {
        if (this.codeSelectorTarget != null) {
            this.codeSelectorTarget.registered(false);
        }
        this.codeSelectorTarget = null;
    }

    public ICodeSelectorTarget getCodeSelectorTarget() {
        return this.codeSelectorTarget;
    }

    public static abstract class CodeSelectorAdapter
    implements ICodeSelectorTarget {
        private StructuredViewer viewer;
        private Color normalColor;
        private Color highlightColor;

        public CodeSelectorAdapter(StructuredViewer viewer) {
            this.viewer = viewer;
            this.normalColor = viewer.getControl().getBackground();
            this.highlightColor = viewer.getControl().getDisplay().getSystemColor(3);
        }

        @Override
        public void registered(boolean registered) {
            if (!this.viewer.getControl().isDisposed()) {
                if (registered) {
                    this.viewer.getControl().setBackground(this.highlightColor);
                } else {
                    this.viewer.getControl().setBackground(this.normalColor);
                }
            }
        }
    }
}

