/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.data.Query;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDataLoaderJob
extends BackgroundJob {
    protected Query qbe;
    protected String[] orderBy;
    private boolean orderReverse;
    protected LinkedList<FilterProvider> fp = new LinkedList();

    protected AbstractDataLoaderJob(String name, Query q, String[] order) {
        super(name);
        this.qbe = q;
        this.orderBy = order;
    }

    protected List load() {
        if (this.fp != null) {
            for (FilterProvider f : this.fp) {
                if (f == null) continue;
                f.applyFilter();
            }
        }
        this.qbe.orderBy(this.orderReverse, this.orderBy);
        return this.qbe.execute();
    }

    public void setReverseOrder(boolean reverse) {
        this.orderReverse = reverse;
    }

    public Query getQuery() {
        return this.qbe;
    }

    public void setOrder(String ... order) {
        this.orderBy = order;
        this.invalidate();
    }

    public String[] getOrder() {
        return this.orderBy;
    }

    public void addFilterProvider(FilterProvider f) {
        this.fp.add(f);
    }

    public void removeFilterProvider(FilterProvider f) {
        this.fp.remove(f);
    }

    public static interface FilterProvider {
        public void applyFilter();
    }
}

