/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.perspective.handler;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.perspective.service.IPerspectiveExportService;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class PerspektiveExportHandler
extends AbstractHandler {
    static IPerspectiveExportService perspectiveExportService;

    @Reference(unbind="-")
    public void bind(IPerspectiveExportService service) {
        perspectiveExportService = service;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dialog = new FileDialog(UiDesk.getTopShell(), 8192);
        dialog.setFilterNames(new String[]{"XMI"});
        dialog.setFilterExtensions(new String[]{"*.xmi"});
        dialog.setFilterPath(CoreHub.getWritableUserDir().getAbsolutePath());
        dialog.setFileName("perspective_export.xmi");
        String path = dialog.open();
        if (path != null) {
            try {
                perspectiveExportService.exportPerspective(path, null, null);
                MessageDialog.openInformation((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Export", (String)"Die aktuelle Perspektive wurde erfolgreich exportiert.");
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Export", (String)"Die aktuelle Perspektive kann nicht exportiert werden.");
                LoggerFactory.getLogger(PerspektiveExportHandler.class).error("export error", (Throwable)e);
            }
        }
        return null;
    }
}

