/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.medication.views.MedicationCellLabelProvider;
import ch.elexis.core.ui.medication.views.MedicationComposite;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationViewHelper;
import ch.elexis.core.ui.medication.views.Messages;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import java.text.MessageFormat;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class MedicationViewerHelper {
    public static TableViewerColumn createTypeColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 0);
        TableColumn tblclmnStateDisposition = ret.getColumn();
        tblclmnStateDisposition.setToolTipText(String.valueOf(Messages.MedicationComposite_column_sortBy) + " " + Messages.Core_Type);
        layout.setColumnData((Widget)tblclmnStateDisposition, (ColumnLayoutData)new ColumnPixelData(20, false, false));
        tblclmnStateDisposition.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnStateDisposition, columnIndex));
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                return ((MedicationTableViewerItem)element).getImage();
            }
        });
        return ret;
    }

    public static TableViewerColumn createArticleColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 0);
        TableColumn tblclmnArticle = ret.getColumn();
        layout.setColumnData((Widget)tblclmnArticle, (ColumnLayoutData)new ColumnPixelData(250, true, true));
        tblclmnArticle.setText(Messages.Core_Article);
        tblclmnArticle.setToolTipText(String.valueOf(Messages.MedicationComposite_column_sortBy) + " " + Messages.Core_Article);
        tblclmnArticle.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnArticle, columnIndex));
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                MedicationTableViewerItem pres = (MedicationTableViewerItem)element;
                return pres.getArtikelLabel();
            }

            public String getToolTipText(Object element) {
                MedicationTableViewerItem pres = (MedicationTableViewerItem)element;
                String label = "";
                if (pres.isActiveMedication()) {
                    String endDate;
                    String date = pres.getBeginDate();
                    if (date != null && !date.isEmpty()) {
                        label = MessageFormat.format(Messages.MedicationComposite_startedAt, date);
                    }
                    if ((endDate = pres.getEndDate()) != null && !endDate.isEmpty()) {
                        String reason = pres.getStopReason() == null ? "?" : pres.getStopReason();
                        label = String.valueOf(label) + "\n" + MessageFormat.format(Messages.MedicationComposite_stopDateAndReason, endDate, reason);
                    }
                } else {
                    IRecipe recipe = pres.getRecipe();
                    IBilled billed = pres.getBilled();
                    if (recipe != null || billed != null) {
                        if (recipe != null) {
                            label = MessageFormat.format(Messages.MedicationComposite_lastReceivedAt, DateTimeFormatter.ofPattern("dd.MM.yyyy").format(recipe.getDate()));
                        } else if (billed != null && billed.getEncounter() != null) {
                            label = MessageFormat.format(Messages.MedicationComposite_lastReceivedAt, DateTimeFormatter.ofPattern("dd.MM.yyyy").format(billed.getEncounter().getDate()));
                        }
                    } else {
                        String date = pres.getEndDate();
                        String reason = pres.getStopReason() == null ? "?" : pres.getStopReason();
                        label = MessageFormat.format(Messages.MedicationComposite_stopDateAndReason, date, reason);
                    }
                }
                return label;
            }
        });
        return ret;
    }

    public static TableViewerColumn createDosageColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 0);
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                MedicationTableViewerItem pres = (MedicationTableViewerItem)element;
                String dosis = pres.getDosis();
                return dosis.equals("0") ? Messages.MedicationComposite_stopped : dosis;
            }
        });
        TableColumn tblclmnDosage = ret.getColumn();
        tblclmnDosage.setToolTipText(Messages.TherapieplanComposite_tblclmnDosage_toolTipText);
        tblclmnDosage.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnDosage, columnIndex));
        layout.setColumnData((Widget)tblclmnDosage, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        ret.getColumn().setText(Messages.TherapieplanComposite_tblclmnDosage_text);
        return ret;
    }

    public static TableViewerColumn createBeginColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 0x1000000);
        TableColumn tblclmnEnacted = ret.getColumn();
        layout.setColumnData((Widget)tblclmnEnacted, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        tblclmnEnacted.setImage(Images.resize((Image)Images.IMG_NEXT_WO_SHADOW.getImage(), (ImageSize)ImageSize._12x12_TableColumnIconSize));
        tblclmnEnacted.setToolTipText(String.valueOf(Messages.MedicationComposite_column_sortBy) + " " + Messages.Core_Date_Startdate);
        tblclmnEnacted.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnEnacted, columnIndex));
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                MedicationTableViewerItem pres = (MedicationTableViewerItem)element;
                return pres.getBeginDate();
            }
        });
        return ret;
    }

    public static TableViewerColumn createIntakeCommentColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 0);
        TableColumn tblclmnComment = ret.getColumn();
        layout.setColumnData((Widget)tblclmnComment, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tblclmnComment.setText(Messages.Prescription_Instruction);
        tblclmnComment.setToolTipText(String.valueOf(Messages.MedicationComposite_column_sortBy) + " " + Messages.Prescription_Instruction);
        tblclmnComment.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnComment, columnIndex));
        tblclmnComment.setToolTipText(String.valueOf(Messages.MedicationComposite_column_sortBy) + " " + Messages.Prescription_Instruction);
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                MedicationTableViewerItem pres = (MedicationTableViewerItem)element;
                return pres.getRemark();
            }
        });
        return ret;
    }

    public static TableViewerColumn createStopColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 0x1000000);
        TableColumn tblclmnStop = ret.getColumn();
        ColumnPixelData stopColumnPixelData = new ColumnPixelData(60, true, true);
        layout.setColumnData((Widget)tblclmnStop, (ColumnLayoutData)stopColumnPixelData);
        tblclmnStop.setImage(Images.resize((Image)Images.IMG_ARROWSTOP_WO_SHADOW.getImage(), (ImageSize)ImageSize._12x12_TableColumnIconSize));
        tblclmnStop.setToolTipText(String.valueOf(Messages.MedicationComposite_column_sortBy) + " " + Messages.MedicationComposite_column_endDate);
        tblclmnStop.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnStop, columnIndex));
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                MedicationTableViewerItem pres = (MedicationTableViewerItem)element;
                if (pres.getEntryType() != EntryType.RECIPE && pres.getEntryType() != EntryType.SELF_DISPENSED) {
                    return pres.getEndDate();
                }
                return "";
            }
        });
        return ret;
    }

    public static TableViewerColumn createStopReasonColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 16384);
        TableColumn tblclmnReason = ret.getColumn();
        ColumnWeightData reasonColumnWeightData = new ColumnWeightData(1, 20, true);
        layout.setColumnData((Widget)tblclmnReason, (ColumnLayoutData)reasonColumnWeightData);
        tblclmnReason.setText(Messages.MedicationComposite_stopReason);
        tblclmnReason.setToolTipText(String.valueOf(Messages.MedicationComposite_column_sortBy) + " " + Messages.MedicationComposite_stopReason);
        tblclmnReason.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnReason, columnIndex));
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                String stopReason;
                MedicationTableViewerItem pres = (MedicationTableViewerItem)element;
                if (pres.getEntryType() != EntryType.RECIPE && pres.getEntryType() != EntryType.SELF_DISPENSED && (stopReason = pres.getStopReason()) != null && !stopReason.isEmpty()) {
                    return stopReason;
                }
                return "";
            }
        });
        return ret;
    }

    public static TableViewerColumn createMandantColumn(TableViewer viewer, TableColumnLayout layout, int columnIndex) {
        TableViewerColumn ret = new TableViewerColumn(viewer, 16384);
        TableColumn tblclmnMandant = ret.getColumn();
        ColumnWeightData mandantColumnWeightData = new ColumnWeightData(0, 50, true);
        layout.setColumnData((Widget)tblclmnMandant, (ColumnLayoutData)mandantColumnWeightData);
        tblclmnMandant.setText(Messages.Core_User);
        tblclmnMandant.setToolTipText(Messages.Core_User);
        tblclmnMandant.addSelectionListener((SelectionListener)MedicationViewerHelper.getSelectionAdapter(viewer, tblclmnMandant, columnIndex));
        ret.setLabelProvider((CellLabelProvider)new MedicationCellLabelProvider(){

            public String getText(Object element) {
                return ((MedicationTableViewerItem)element).getPrescriptorLabel();
            }
        });
        return ret;
    }

    public static void addContextMenu(TableViewer viewer, MedicationComposite medicationComposite, IWorkbenchPartSite site) {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)viewer.getTable());
        viewer.getTable().setMenu(menu);
        if (site != null) {
            site.registerContextMenu("ch.elexis.core.ui.medication.tables", menuManager, (ISelectionProvider)viewer);
        }
    }

    private static SelectionAdapter getSelectionAdapter(final TableViewer viewer, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerSortOrder comparator = MedicationViewHelper.getSelectedComparator();
                if (ViewerSortOrder.DEFAULT.equals((Object)comparator)) {
                    comparator.setColumn(index);
                    int dir = comparator.getDirection();
                    viewer.getTable().setSortColumn(column);
                    viewer.getTable().setSortDirection(dir);
                    viewer.refresh(true);
                }
            }
        };
        return selectionAdapter;
    }
}

