/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.laboratory.controls.LaborOrdersComposite;
import ch.elexis.core.ui.laboratory.controls.LaborResultsComposite;
import ch.elexis.core.ui.laboratory.dialogs.LaborVerordnungDialog;
import ch.elexis.core.ui.laboratory.views.LaborOrderPulldownMenuCreator;
import ch.elexis.core.ui.laboratory.views.LaborblattView;
import ch.elexis.core.ui.util.Importer;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class LaborView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.Labor";
    private static Log log = Log.get((String)"LaborView");
    private CTabFolder tabFolder;
    private LaborResultsComposite resultsComposite;
    private LaborOrdersComposite ordersComposite;
    private Action fwdAction;
    private Action backAction;
    private Action printAction;
    private Action importAction;
    private Action xmlAction;
    private Action newAction;
    private Action newColumnAction;
    private Action refreshAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private ViewMenus menu;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);
    private ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            if (!LaborView.this.resultsComposite.isDisposed() && !LaborView.this.ordersComposite.isDisposed()) {
                LaborView.this.resultsComposite.selectPatient((Patient)ev.getObject());
                LaborView.this.ordersComposite.selectPatient((Patient)ev.getObject());
            }
        }
    };
    private ElexisEventListener eeli_labitem = new ElexisEventListener(){
        private final ElexisEvent eetmpl = new ElexisEvent(null, LabItem.class, 8);

        public ElexisEvent getElexisEventFilter() {
            return this.eetmpl;
        }

        public void catchElexisEvent(ElexisEvent ev) {
            UiDesk.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).LaborView.this.resultsComposite.reload();
                }
            });
        }
    };
    private ElexisEventListener eeli_labresult = new ElexisEventListener(){
        private final ElexisEvent eetmpl = new ElexisEvent(null, LabResult.class, 8);

        public ElexisEvent getElexisEventFilter() {
            return this.eetmpl;
        }

        public void catchElexisEvent(ElexisEvent ev) {
            UiDesk.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).LaborView.this.resultsComposite.reload();
                    (this).LaborView.this.ordersComposite.reload();
                }
            });
        }
    };
    private ElexisEventListener eeli_laborder = new ElexisEventListener(){
        private final ElexisEvent eetmpl = new ElexisEvent(null, LabOrder.class, 8);

        public ElexisEvent getElexisEventFilter() {
            return this.eetmpl;
        }

        public void catchElexisEvent(ElexisEvent ev) {
            UiDesk.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).LaborView.this.ordersComposite.reload();
                }
            });
        }
    };

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.IMG_VIEW_LABORATORY.getImage());
        this.tabFolder = new CTabFolder(parent, 128);
        this.tabFolder.setLayout((Layout)new FillLayout());
        CTabItem resultsTabItem = new CTabItem(this.tabFolder, 0);
        resultsTabItem.setText("Resultate");
        this.resultsComposite = new LaborResultsComposite((Composite)this.tabFolder, 0);
        resultsTabItem.setControl((Control)this.resultsComposite);
        CTabItem ordersTabItem = new CTabItem(this.tabFolder, 0);
        ordersTabItem.setText("Verordnungen");
        this.ordersComposite = new LaborOrdersComposite((Composite)this.tabFolder, 0);
        ordersTabItem.setControl((Control)this.ordersComposite);
        this.tabFolder.setSelection(0);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaborView.this.resultsComposite.reload();
                LaborView.this.ordersComposite.reload();
            }
        });
        this.makeActions();
        this.menu = new ViewMenus(this.getViewSite());
        this.menu.createMenu(new IAction[]{this.newAction, this.backAction, this.fwdAction, this.printAction, this.importAction, this.xmlAction});
        LaborOrderPulldownMenuCreator menuCreator = new LaborOrderPulldownMenuCreator(parent.getShell());
        if (menuCreator.getSelected() != null) {
            IAction dropDownAction = menuCreator.getAction();
            IActionBars actionBars = this.getViewSite().getActionBars();
            IToolBarManager toolbar = actionBars.getToolBarManager();
            toolbar.add(dropDownAction);
            dropDownAction.setText(menuCreator.getSelected().getText());
            dropDownAction.setToolTipText(menuCreator.getSelected().getToolTipText());
            dropDownAction.setImageDescriptor(menuCreator.getSelected().getImageDescriptor());
        }
        IToolBarManager tm = this.getViewSite().getActionBars().getToolBarManager();
        List importers = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.LaborDatenImport"), (String)"ToolbarAction", (boolean)false);
        for (IAction ac : importers) {
            tm.add(ac);
        }
        if (importers.size() > 0) {
            tm.add((IContributionItem)new Separator());
        }
        tm.add((IAction)this.refreshAction);
        tm.add((IAction)this.newColumnAction);
        tm.add((IAction)this.newAction);
        tm.add((IAction)this.backAction);
        tm.add((IAction)this.fwdAction);
        tm.add((IAction)this.expandAllAction);
        tm.add((IAction)this.collapseAllAction);
        tm.add((IAction)this.printAction);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_labitem, this.eeli_laborder, this.eeli_labresult, this.eeli_pat});
        Patient act = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        if (act != null && act != this.resultsComposite.getPatient()) {
            this.resultsComposite.selectPatient(act);
        }
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_labitem, this.eeli_laborder, this.eeli_labresult, this.eeli_pat});
        super.dispose();
    }

    public void setFocus() {
        if (this.resultsComposite.isVisible()) {
            this.resultsComposite.setFocus();
        } else if (this.ordersComposite.isVisible()) {
            this.ordersComposite.setFocus();
        }
    }

    public void refresh() {
        this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
    }

    private void makeActions() {
        this.fwdAction = new Action(Messages.LaborView_nextPage){

            public void run() {
                LaborView.this.resultsComposite.setColumnOffset(LaborView.this.resultsComposite.getColumnOffset() + 1);
                LaborView.this.resultsComposite.reload();
                LaborView.this.tabFolder.setSelection(0);
            }
        };
        this.backAction = new Action(Messages.LaborView_prevPage){

            public void run() {
                LaborView.this.resultsComposite.setColumnOffset(LaborView.this.resultsComposite.getColumnOffset() - 1);
                LaborView.this.resultsComposite.reload();
                LaborView.this.tabFolder.setSelection(0);
            }
        };
        this.printAction = new Action(Messages.Core_Print_ellipsis){

            public void run() {
                try {
                    LaborblattView lb = (LaborblattView)LaborView.this.getViewSite().getPage().showView("ch.elexis.Laborblatt");
                    Patient pat = ElexisEventDispatcher.getSelectedPatient();
                    lb.createLaborblatt(pat, LaborView.this.resultsComposite.getPrintHeaders(), LaborView.this.resultsComposite.getPrintRows(), LaborView.this.resultsComposite.getSkipIndex());
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.importAction = new Action(Messages.Core_Import_Action){
            {
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
                this.setToolTipText(Messages.LaborView_importToolTip);
            }

            public void run() {
                Importer imp = new Importer(LaborView.this.getViewSite().getShell(), "ch.elexis.core.ui.LaborDatenImport");
                imp.create();
                imp.setMessage(Messages.Core_Choose_Import_Source);
                imp.getShell().setText(Messages.LaborView_labImporterCaption);
                imp.setTitle(Messages.LaborView_labImporterText);
                imp.open();
            }
        };
        this.xmlAction = new Action(Messages.LaborView_xmlExport){

            public void run() {
                FileDialog fsel;
                String fname;
                Document doc = LaborView.this.makeXML();
                if (doc != null && (fname = (fsel = new FileDialog(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell())).open()) != null) {
                    try {
                        FileOutputStream fout = new FileOutputStream(fname);
                        OutputStreamWriter cout = new OutputStreamWriter((OutputStream)fout, "UTF-8");
                        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                        xout.output(doc, (Writer)cout);
                        cout.close();
                        fout.close();
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        SWTHelper.alert((String)Messages.Core_Error, (String)(String.valueOf(Messages.LaborView_couldntwrite) + fname));
                    }
                }
            }
        };
        this.newColumnAction = new Action(Messages.Core_prescribe_Laboratory){

            public void run() {
                LaborView.this.tabFolder.setSelection(0);
                LaborView.this.resultsComposite.toggleNewColumn();
            }
        };
        this.newAction = new Action(Messages.Core_prescribe_Laboratory){

            public void run() {
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient == null) {
                    return;
                }
                TimeTool date = new TimeTool();
                LaborVerordnungDialog dialog = new LaborVerordnungDialog(LaborView.this.getSite().getShell(), patient, date);
                if (dialog.open() == 0) {
                    LaborView.this.tabFolder.setSelection(1);
                }
            }
        };
        this.refreshAction = new Action(Messages.Core_Update){

            public void run() {
                LaborView.this.resultsComposite.reload();
                LaborView.this.ordersComposite.reload();
            }
        };
        this.expandAllAction = new Action(Messages.LaborView_expand_all){

            public void run() {
                if (LaborView.this.tabFolder.getSelectionIndex() == 0) {
                    LaborView.this.resultsComposite.expandAll();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_ARROWDOWN.getImageDescriptor();
            }
        };
        this.collapseAllAction = new Action(Messages.LaborView_collapse_all){

            public void run() {
                if (LaborView.this.tabFolder.getSelectionIndex() == 0) {
                    LaborView.this.resultsComposite.collapseAll();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_ARROWUP.getImageDescriptor();
            }
        };
        this.newColumnAction.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
        this.newAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        this.fwdAction.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
        this.backAction.setImageDescriptor(Images.IMG_PREVIOUS.getImageDescriptor());
        this.printAction.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
        this.xmlAction.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
        this.refreshAction.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
    }

    public Document makeXML() {
        Document doc = null;
        try {
            doc = new Document();
            Element r = new Element("Laborblatt");
            r.setAttribute("Erstellt", new TimeTool().toString(0));
            Patient actpat = ElexisEventDispatcher.getSelectedPatient();
            if (actpat == null) {
                return doc;
            }
            r.setAttribute("Patient", actpat.getLabel());
            doc.setRootElement(r);
            Element Daten = new Element("Daten");
            r.setAttribute("Patient", actpat.getLabel());
            HashMap groupedResults = LabResult.getGrouped((Patient)actpat);
            List<String> dates = this.getDates(groupedResults);
            for (String d : dates) {
                Element dat = new Element("Datum");
                dat.setAttribute("Tag", d);
                Daten.addContent((Content)dat);
            }
            r.addContent((Content)Daten);
            ArrayList groupNames = new ArrayList();
            groupNames.addAll(groupedResults.keySet());
            for (String g : groupNames) {
                Element eGroup = new Element("Gruppe");
                eGroup.setAttribute("Name", g);
                HashMap itemMap = (HashMap)groupedResults.get(g);
                List<LabItem> items = this.getItems(itemMap);
                if (items == null) {
                    log.log("Ung\u00fcltige Gruppe " + g, 3);
                    continue;
                }
                if (items.size() == 0) continue;
                for (LabItem it : items) {
                    Element eItem = new Element("Parameter");
                    eItem.setAttribute("Name", it.getName());
                    eItem.setAttribute("K\u00fcrzel", it.getKuerzel());
                    eItem.setAttribute("Einheit", it.getEinheit());
                    HashMap resultsPerDate = (HashMap)itemMap.get(it.getShortLabel());
                    Set resultDates = resultsPerDate.keySet();
                    for (String date : resultDates) {
                        List results = (List)resultsPerDate.get(date);
                        Element eResult = new Element("Resultat");
                        eResult.setAttribute("Datum", date);
                        eItem.addContent((Content)eResult);
                        for (LabResult lr : results) {
                            eResult.addContent(lr.getResult());
                        }
                        Element ref = new Element("Referenz");
                        ref.setAttribute("m", it.get("RefMann"));
                        ref.setAttribute("w", it.get("RefFrauOrTx"));
                        eItem.addContent((Content)ref);
                    }
                    eGroup.addContent((Content)eItem);
                }
                if (eGroup.getContentSize() == 0) continue;
                r.addContent((Content)eGroup);
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        return doc;
    }

    private List<LabItem> getItems(HashMap<String, HashMap<String, List<LabResult>>> itemMap) {
        Set<String> keys = itemMap.keySet();
        ArrayList<LabItem> ret = new ArrayList<LabItem>();
        for (String string : keys) {
            Collection<List<LabResult>> values = itemMap.get(string).values();
            if (values.isEmpty()) continue;
            Iterator<List<LabResult>> iter = values.iterator();
            List<LabResult> first = iter.next();
            while (first.isEmpty() && iter.hasNext()) {
                first = iter.next();
            }
            ret.add((LabItem)first.get(0).getItem());
        }
        return ret;
    }

    public List<String> getDates(HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> map) {
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<String> dateStrings = new HashSet<String>();
        for (String group : map.keySet()) {
            HashMap<String, HashMap<String, List<LabResult>>> itemMap = map.get(group);
            for (String item : itemMap.keySet()) {
                dateStrings.addAll(itemMap.get(item).keySet());
            }
        }
        ret.addAll(dateStrings);
        Collections.sort(ret);
        return ret;
    }

    public void activation(boolean mode) {
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    public void reloadContents(Class clazz) {
        clazz.equals(LabItem.class);
    }
}

