/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.views;

import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.laboratory.views.Messages;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.data.Brief;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabOrder;
import ch.elexis.data.Patient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class LabOrderView
extends ViewPart
implements ITextPlugin.ICallback {
    public static final String ID = "ch.elexis.core.ui.laboratory.LabOrderView";
    private static final String LABORDER_PLACEHOLDER = "[Verordnung]";
    private TextContainer text;
    private String[] headers = new String[]{Messages.LabOrderView_Order, Messages.LabOrderView_RefValue, Messages.Core_Date_Time, Messages.LabOrderView_Value};

    public void createPartControl(Composite parent) {
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, (ITextPlugin.ICallback)this);
    }

    public boolean createLabOrderPrint(Patient pat, List<LabOrder> labOrders) {
        Brief br = this.text.createFromTemplateName(Konsultation.getAktuelleKons(), "Verordnungen", "Labor", (Kontakt)pat, null);
        if (br == null) {
            return false;
        }
        if (!labOrders.isEmpty()) {
            String orderId = labOrders.get(0).get("orderid");
            this.text.getPlugin().insertText("[AuftragsNr]", orderId, 16384);
        }
        String[][] content = this.populateLabOrderTable(labOrders, pat.getGeschlecht());
        boolean ret = this.text.getPlugin().insertTable(LABORDER_PLACEHOLDER, 1, content, null);
        this.text.saveBrief(br, "Labor");
        return ret;
    }

    private String[][] populateLabOrderTable(List<LabOrder> labOrders, String patientGender) {
        LinkedList<String[]> usedRows = new LinkedList<String[]>();
        usedRows.add(this.headers);
        Map<String, List<LabOrder>> groupMap = this.groupLabOrders(labOrders);
        ArrayList<String> keySet = new ArrayList<String>(groupMap.keySet());
        Collections.sort(keySet);
        for (String groupKey : keySet) {
            List<LabOrder> gLabOrders = groupMap.get(groupKey);
            usedRows.add(this.createRow(groupKey, "", ""));
            for (LabOrder labOrder : gLabOrders) {
                if (labOrder.getState() != LabOrder.State.ORDERED) continue;
                LabItem labItem = labOrder.getLabItem();
                String ref = "";
                ref = "w".equals(patientGender) ? labItem.getRefW() : labItem.getRefM();
                usedRows.add(this.createRow("\t" + labItem.getName(), ref, labItem.getEinheit()));
            }
        }
        return (String[][])usedRows.toArray((T[])new String[0][]);
    }

    private String[] createRow(String value, String ref, String unit) {
        Object[] row = new String[4];
        Arrays.fill(row, "");
        row[0] = value;
        if (!ref.isEmpty()) {
            row[1] = String.valueOf(ref) + " " + unit;
        }
        return row;
    }

    private Map<String, List<LabOrder>> groupLabOrders(List<LabOrder> labOrders) {
        HashMap<String, List<LabOrder>> gloMap = new HashMap<String, List<LabOrder>>();
        for (LabOrder labOrder : labOrders) {
            String group = labOrder.get("groupname");
            ArrayList<LabOrder> orders = (ArrayList<LabOrder>)gloMap.get(group);
            if (orders == null) {
                orders = new ArrayList<LabOrder>();
            }
            orders.add(labOrder);
            gloMap.put(group, orders);
        }
        return gloMap;
    }

    public void setFocus() {
    }

    public void save() {
    }

    public boolean saveAs() {
        return false;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

