/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.preferences;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Labor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class HL7LabImportRulesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer labMPathMNonPathListViewer;

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblLabNoPathFlagMeansNonPath = new Label(composite, 64);
        lblLabNoPathFlagMeansNonPath.setText(Messages.HL7LabImportRulesPreferencePage_lblLabImportRulesHeader_text);
        ToolBarManager toolbarmgr = new ToolBarManager();
        toolbarmgr.add((IAction)new AddMissingPathFlagMeansNonPathLaboratoryAction());
        toolbarmgr.add((IAction)new RemoveMissingPathFlagMeansNonPathLaboratoryAction());
        ToolBar toolbar = toolbarmgr.createControl(composite);
        toolbar.setLayoutData((Object)new GridData(131072, 128, false, false));
        new Label(composite, 0);
        this.labMPathMNonPathListViewer = new ListViewer(composite, 2560);
        this.labMPathMNonPathListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.labMPathMNonPathListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Kontakt) {
                    return ((Kontakt)element).getLabel();
                }
                return super.getText(element);
            }
        });
        GridData gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        gridData.heightHint = 80;
        this.labMPathMNonPathListViewer.getList().setLayoutData((Object)gridData);
        this.labMPathMNonPathListViewer.setInput(this.findAllLabsWithPathFlagMissingMeansNonPathologic());
        return container;
    }

    private Set<Labor> findAllLabsWithPathFlagMissingMeansNonPathologic() {
        List laboratoryIdList = ConfigServiceHolder.getGlobalAsList((String)"lab/eval/missingPathologicFlagMeansNonPathologicFor");
        return new HashSet<Labor>(laboratoryIdList.stream().map(id -> Labor.load((String)id)).collect(Collectors.toList()));
    }

    protected void performApply() {
        super.performApply();
    }

    public void init(IWorkbench workbench) {
    }

    private class AddMissingPathFlagMeansNonPathLaboratoryAction
    extends Action {
        private AddMissingPathFlagMeansNonPathLaboratoryAction() {
            this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
        }

        public void run() {
            KontaktSelektor dialog = new KontaktSelektor(HL7LabImportRulesPreferencePage.this.getShell(), Labor.class, Messages.Core_Select_Laboratory, Messages.Core_Select_Laboratory, Kontakt.DEFAULT_SORT);
            if (dialog.open() == 0) {
                Labor contact = (Labor)dialog.getSelection();
                Set<Labor> findAllLabsWithPathFlagMissingMeansNonPathologic = HL7LabImportRulesPreferencePage.this.findAllLabsWithPathFlagMissingMeansNonPathologic();
                if (!findAllLabsWithPathFlagMissingMeansNonPathologic.contains(contact)) {
                    findAllLabsWithPathFlagMissingMeansNonPathologic.add(contact);
                    ConfigServiceHolder.setGlobalAsList((String)"lab/eval/missingPathologicFlagMeansNonPathologicFor", findAllLabsWithPathFlagMissingMeansNonPathologic.stream().map(l -> l.getId()).collect(Collectors.toList()));
                    HL7LabImportRulesPreferencePage.this.labMPathMNonPathListViewer.setInput(HL7LabImportRulesPreferencePage.this.findAllLabsWithPathFlagMissingMeansNonPathologic());
                }
            }
        }
    }

    private class RemoveMissingPathFlagMeansNonPathLaboratoryAction
    extends Action {
        private RemoveMissingPathFlagMeansNonPathLaboratoryAction() {
            this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
        }

        public void run() {
            IStructuredSelection selection = HL7LabImportRulesPreferencePage.this.labMPathMNonPathListViewer.getStructuredSelection();
            if (selection != null && !selection.isEmpty()) {
                Labor contact = (Labor)selection.getFirstElement();
                Set<Labor> findAllLabsWithPathFlagMissingMeansNonPathologic = HL7LabImportRulesPreferencePage.this.findAllLabsWithPathFlagMissingMeansNonPathologic();
                findAllLabsWithPathFlagMissingMeansNonPathologic.remove(contact);
                ConfigServiceHolder.setGlobalAsList((String)"lab/eval/missingPathologicFlagMeansNonPathologicFor", findAllLabsWithPathFlagMissingMeansNonPathologic.stream().map(l -> l.getId()).collect(Collectors.toList()));
                HL7LabImportRulesPreferencePage.this.labMPathMNonPathListViewer.remove((Object)contact);
            }
        }
    }
}

