/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.fieldassist;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.e4.fieldassist.AsyncContentProposalProvider;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PatientSearchToken {
    private boolean ignore;
    private boolean lastname;
    private boolean firstname;
    private boolean name;
    private String token;
    private DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyyMMdd");

    private PatientSearchToken(String token) {
        this.token = token;
    }

    public void setIsIgnore() {
        this.ignore = true;
    }

    public void setIsFirstname() {
        this.firstname = true;
    }

    public void setIsLastname() {
        this.lastname = true;
    }

    public void setIsName() {
        this.name = true;
    }

    public static PatientSearchToken of(String string) {
        PatientSearchToken ret = new PatientSearchToken(string);
        return ret;
    }

    public void apply(IQuery<?> query) {
        if (this.isPatientCode()) {
            query.and("code", IQuery.COMPARATOR.EQUALS, (Object)this.token.substring(1));
        } else if (this.isDate()) {
            query.and("dob", IQuery.COMPARATOR.LIKE, (Object)AsyncContentProposalProvider.getElexisDateSearchString(this.token));
        } else if (this.lastname) {
            query.and("description1", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(this.token) + "%"), true);
        } else if (this.firstname) {
            query.and("description2", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(this.token) + "%"), true);
        } else if (this.name) {
            query.startGroup();
            query.or("description1", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(this.token) + "%"), true);
            query.or("description2", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(this.token) + "%"), true);
            query.andJoinGroups();
        }
    }

    public boolean test(IPatient patient) {
        if (this.isPatientCode()) {
            return patient.getCode().equals(this.token.substring(1));
        }
        if (this.isDate() && patient.getDateOfBirth() != null) {
            String searchToken = AsyncContentProposalProvider.getElexisDateSearchString(this.token);
            String compareToken = searchToken.replaceAll("%", "");
            if (searchToken.startsWith("%")) {
                return this.timestampFormat.format(patient.getDateOfBirth()).endsWith(compareToken);
            }
            return this.timestampFormat.format(patient.getDateOfBirth()).startsWith(compareToken);
        }
        if (this.lastname) {
            return patient.getDescription1().toLowerCase().startsWith(this.token.toLowerCase());
        }
        if (this.firstname) {
            return patient.getDescription2().toLowerCase().startsWith(this.token.toLowerCase());
        }
        if (this.name) {
            return patient.getDescription1().toLowerCase().startsWith(this.token.toLowerCase()) || patient.getDescription2().toLowerCase().startsWith(this.token.toLowerCase());
        }
        return false;
    }

    boolean isNameToken() {
        return !this.isDate() && !this.isPatientCode() && StringUtils.isNotBlank((CharSequence)this.token);
    }

    private boolean isDate() {
        if (this.token.length() == 4 && StringUtils.isNumeric((CharSequence)this.token)) {
            return true;
        }
        return this.token.length() > 2 && this.token.matches("[0-9\\.]+");
    }

    private boolean isPatientCode() {
        return this.token.length() > 1 && this.token.startsWith("#");
    }

    public boolean ignore() {
        return this.ignore;
    }

    public static List<PatientSearchToken> getPatientSearchTokens(String[] split) {
        if (split != null && split.length > 0) {
            List tokens = Arrays.asList(split).stream().map(s -> PatientSearchToken.of(s)).collect(Collectors.toList());
            List nameTokens = tokens.stream().filter(st -> st.isNameToken()).collect(Collectors.toList());
            int i = 0;
            while (i < nameTokens.size()) {
                if (i == 0 && nameTokens.size() == 1) {
                    ((PatientSearchToken)nameTokens.get(i)).setIsName();
                } else if (i == 0) {
                    ((PatientSearchToken)nameTokens.get(i)).setIsLastname();
                } else if (i == 1) {
                    ((PatientSearchToken)nameTokens.get(i)).setIsFirstname();
                } else {
                    ((PatientSearchToken)nameTokens.get(i)).setIsIgnore();
                }
                ++i;
            }
            return tokens.stream().filter(st -> !st.ignore()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

