/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SetMobileOfContact
extends ExternalMaintenance {
    private static final Pattern SWISS = Pattern.compile("^(07[5-9])(\\d{3})(\\d{2})(\\d{2})$");
    private static final Pattern PREFIXSWISS = Pattern.compile("^((\\+|00)41)(7[5-9])(\\d{3})(\\d{2})(\\d{2})$");
    int count;
    int countLock;
    String newPhone;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        IQuery contactQuery = CoreModelServiceHolder.get().getQuery(IContact.class);
        contactQuery.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__ORGANIZATION, IQuery.COMPARATOR.EQUALS, (Object)false);
        contactQuery.startGroup();
        contactQuery.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__MOBILE, IQuery.COMPARATOR.EQUALS, (Object)"");
        contactQuery.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__MOBILE, IQuery.COMPARATOR.EQUALS, null);
        this.count = 0;
        this.countLock = 0;
        Throwable throwable = null;
        Object var5_6 = null;
        try (IQueryCursor cursor = contactQuery.executeAsCursor();){
            pm.beginTask("Kontaktdaten bearbeiten", cursor.size());
            while (cursor.hasNext()) {
                IContact patient = (IContact)cursor.next();
                if (StringUtils.isNotBlank((CharSequence)patient.getPhone1())) {
                    this.checkPhone(patient, patient.getPhone1());
                } else if (StringUtils.isNotBlank((CharSequence)patient.getPhone2())) {
                    this.checkPhone(patient, patient.getPhone2());
                }
                cursor.clear();
                pm.worked(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        pm.done();
        return String.valueOf(this.count) + " Kontake wurden erfolgreich bearbeitet\n" + this.countLock + " Kontakte sind gesperrt";
    }

    @Override
    public String getMaintenanceDescription() {
        return "Setzt Mobilnummer des Kontaktes, falls in anderem Feld vorhanden";
    }

    private void checkPhone(IContact patient, String phone) {
        this.newPhone = phone.replaceAll("[^0-9+]", "");
        if (SWISS.matcher(this.newPhone).find() || PREFIXSWISS.matcher(this.newPhone).find()) {
            patient.setMobile(this.newPhone);
            LockResponse lock = LocalLockServiceHolder.get().acquireLock((Object)patient);
            if (lock.isOk()) {
                CoreModelServiceHolder.get().save((Identifiable)patient);
                LocalLockServiceHolder.get().releaseLock((Object)patient);
                ++this.count;
            } else {
                ++this.countLock;
            }
        }
    }
}

