/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.LabResult;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LabResetPathologic
extends ExternalMaintenance {
    private List<String> problems = new ArrayList<String>();

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Query qlr = new Query(LabResult.class);
        List results = qlr.execute();
        int size = results.size();
        pm.beginTask(String.valueOf(this.getMaintenanceDescription()) + " (" + size + " Laborwerte)", results.size());
        int allCount = 0;
        int changedCount = 0;
        for (LabResult labResult : results) {
            if (pm.isCanceled()) {
                this.addProblem("Cancelled.", labResult);
                return String.valueOf(this.getProblemsString()) + "\n" + changedCount + " Werte wurden ge\u00e4ndert.\n " + allCount + " Werte insgesamt.";
            }
            LockResponse result = LocalLockServiceHolder.get().acquireLockBlocking((Object)labResult, 50, (IProgressMonitor)new NullProgressMonitor());
            if (result.isOk()) {
                LockResponse releaseLock;
                boolean wasPathologic = labResult.isFlag(1);
                labResult.setRefFemale(labResult.getRefFemale());
                labResult.setRefMale(labResult.getRefMale());
                boolean isPathologic = labResult.isFlag(1);
                if (wasPathologic != isPathologic) {
                    ++changedCount;
                }
                if (!(releaseLock = LocalLockServiceHolder.get().releaseLock(result.getLockInfo())).isOk()) {
                    this.addProblem("Could not release lock for LabResult [" + labResult.getLabel() + "]" + "[" + labResult.getId() + "]", labResult);
                }
            } else {
                this.addProblem("Could not acquire lock for LabResult [" + labResult.getLabel() + "]" + "[" + labResult.getId() + "]", labResult);
            }
            if (++allCount % 1000 == 0) {
                PersistentObject.resetCache();
                pm.setTaskName(String.valueOf(this.getMaintenanceDescription()) + " (" + size + " Laborwerte => " + allCount + " bearbeitet)");
            }
            pm.worked(1);
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        pm.done();
        return String.valueOf(changedCount) + " Werte wurden ge\u00e4ndert.\n " + allCount + " Werte insgesamt.";
    }

    private void addProblem(String prefix, LabResult labResult) {
        this.problems.add("[" + prefix + "]" + "[" + labResult.getId() + "] - [" + labResult.getLabel() + "] of [" + labResult.getPatient().getLabel() + "]");
    }

    @Override
    public String getMaintenanceDescription() {
        return "Pathologisch bei allen Laborwerten neu setzen.";
    }

    private String getProblemsString() {
        if (this.problems != null && !this.problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nProblems:\n");
            this.problems.stream().forEach(problem -> {
                StringBuilder stringBuilder2 = sb.append(String.valueOf(problem) + "\n");
            });
            return sb.toString();
        }
        return "";
    }
}

