/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MaritalStatus;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.contacts.dialogs.BezugsKontaktAuswahl;
import ch.elexis.core.ui.dialogs.AddBuchungDialog;
import ch.elexis.core.ui.dialogs.AnschriftEingabeDialog;
import ch.elexis.core.ui.dialogs.KontaktDetailDialog;
import ch.elexis.core.ui.dialogs.KontaktExtDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.dialogs.ZusatzAdresseEingabeDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.ElexisUiSyncEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.medication.views.FixMediDisplay;
import ch.elexis.core.ui.settings.UserSettings;
import ch.elexis.core.ui.util.FilterNonPrintableModifyListener;
import ch.elexis.core.ui.util.InputPanel;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import ch.elexis.core.ui.views.contribution.ViewContributionHelper;
import ch.elexis.core.ui.views.controls.StickerComposite;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Anwender;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Labor;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Xid;
import ch.elexis.data.ZusatzAdresse;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.statushandlers.StatusManager;

public class Patientenblatt2
extends Composite
implements IUnlockable {
    private static final String KEY_DBFIELD = "dbfield";
    private static final String KEY_PATIENTENBLATT = "Patientenblatt/";
    private final FormToolkit tk;
    private InputPanel ipp;
    private IAction removeZAAction;
    private IAction showZAAction;
    private IAction showBKAction;
    private IAction copySelectedContactInfosToClipboardAction;
    private IAction copySelectedAddressesToClipboardAction;
    private IAction removeAdditionalAddressAction;
    private IAction showAdditionalAddressAction;
    public static final String CFG_BEZUGSKONTAKTTYPEN = "views/patientenblatt/Bezugskontakttypen";
    public static final String CFG_EXTRAFIELDS = "views/patientenblatt/extrafelder";
    public static final String SPLITTER = "#!>";
    private final List<IViewContribution> detailComposites = Extensions.getClasses((String)"ch.elexis.core.ui.ViewContribution", (String)"class", (String)"viewId", (String)"ch.elexis.PatDetail_v2");
    private final List<IViewContribution> buttonTabContributions = Extensions.getClasses((String)"ch.elexis.core.ui.ViewContribution", (String)"class", (String)"viewId", (String)"ch.elexis.PatDetail_v2:buttonTab");
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            Patient pat = (Patient)ev.getObject();
            switch (ev.getType()) {
                case 16: {
                    Patient deselectedPatient = Patientenblatt2.this.actPatient;
                    Patientenblatt2.this.setPatient(pat);
                    Patientenblatt2.this.releaseAndRefreshLock((IPersistentObject)deselectedPatient, "ch.elexis.core.ui.command.ToggleCurrentPatientLockCommand");
                    break;
                }
                case 4096: 
                case 16384: {
                    if (!pat.equals((Object)Patientenblatt2.this.actPatient)) break;
                    Patientenblatt2.this.setUnlocked(ev.getType() == 4096);
                    break;
                }
            }
        }
    };
    private final ElexisEventListener eeli_pat_sync = new ElexisUiSyncEventListenerImpl(Patient.class, 8192){

        public void runInUi(ElexisEvent ev) {
            Patient pat = (Patient)ev.getObject();
            if (pat.equals((Object)Patientenblatt2.this.actPatient)) {
                Patientenblatt2.this.save();
            }
        }
    };
    private ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            Patientenblatt2.this.setPatient(ElexisEventDispatcher.getSelectedPatient());
            Patientenblatt2.this.recreateUserpanel();
        }
    };
    private ArrayList<String> lbExpandable = new ArrayList<String>(Arrays.asList(Messages.Core_Diagnosis, Messages.Patientenblatt2_persAnamnesisLbl, Messages.Patientenblatt2_famAnamnesisLbl, Messages.Allergies, Messages.Patientenblatt2_risksLbl, Messages.Core_Remarks));
    private final List<Text> txExpandable = new ArrayList<Text>();
    private ArrayList<String> dfExpandable = new ArrayList<String>(Arrays.asList("Diagnosen", "PersAnamnese", "FamilienAnamnese", "Allergien", "Risiken", "Bemerkung"));
    private final List<ExpandableComposite> ec = new ArrayList<ExpandableComposite>();
    private static final String FIXMEDIKATION = Messages.Core_Fixed_medication;
    private static final int COLUMNCOUNT = 3;
    private final FormText inpAdresse;
    private final ListDisplay<BezugsKontakt> inpZusatzAdresse;
    private final ListDisplay<ZusatzAdresse> additionalAddresses;
    private final FixMediDisplay dmd;
    Patient actPatient;
    IViewSite viewsite;
    private final Hyperlinkreact hr = new Hyperlinkreact();
    private final ScrolledForm form;
    private final ViewMenus viewmenu;
    private final ExpandableComposite ecdm;
    private final ExpandableComposite ecZA;
    private final ExpandableComposite compAdditionalAddresses;
    private boolean bLocked = true;
    private Composite cUserfields;
    Hyperlink hHA;
    private LabeledInputField.InputData comboGeschlecht;
    StickerComposite stickerComposite;
    private Button deceasedBtn;
    private CDateTime deceasedDate;
    private Button increasedTreatmentBtn;

    private void releaseAndRefreshLock(IPersistentObject object, String commandId) {
        if (object != null && LocalLockServiceHolder.get().isLockedLocal((Object)object)) {
            LocalLockServiceHolder.get().releaseLock((Object)object);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
    }

    void recreateUserpanel() {
        String[] userfields;
        if (this.ipp != null) {
            this.ipp.dispose();
            this.ipp = null;
        }
        ArrayList<LabeledInputField.InputData> fields = new ArrayList<LabeledInputField.InputData>(20);
        fields.add(new LabeledInputField.InputData(Messages.Core_Name, "Name", LabeledInputField.InputData.Typ.STRING, null));
        fields.add(new LabeledInputField.InputData(Messages.Core_Firstname, "Vorname", LabeledInputField.InputData.Typ.STRING, null));
        fields.add(new LabeledInputField.InputData(Messages.Core_Enter_Birthdate, "Geburtsdatum", LabeledInputField.InputData.Typ.DATE, null));
        LabeledInputField.IStructuredSelectionResolver ssr = new LabeledInputField.IStructuredSelectionResolver(){

            public StructuredSelection resolveStructuredSelection(String value) {
                if (value.contentEquals("w")) {
                    return new StructuredSelection((Object)Messages.Patient_female_short);
                }
                return new StructuredSelection((Object)Messages.Patient_male_short);
            }
        };
        this.comboGeschlecht = new LabeledInputField.InputData(Messages.Sex, "Geschlecht", null, LabeledInputField.InputData.Typ.COMBO_VIEWER, (IContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String geschlecht = element.toString();
                if (geschlecht.contentEquals("w")) {
                    return Messages.Patient_female_short;
                }
                return Messages.Patient_male_short;
            }
        }, ssr, (Object)new String[]{"m", "w"});
        String toolTip = String.format(Messages.Patient_male_female_tooltip, Messages.Patient_male_short, Messages.Patient_female_short, Messages.Patient_male_long, Messages.Patient_female_long);
        fields.add(this.comboGeschlecht);
        this.comboGeschlecht.setTooltipText(toolTip);
        LabeledInputField.IStructuredSelectionResolver isr = new LabeledInputField.IStructuredSelectionResolver(){

            public StructuredSelection resolveStructuredSelection(String value) {
                MaritalStatus selection = MaritalStatus.byNumericSafe((String)value);
                return new StructuredSelection((Object)selection);
            }
        };
        fields.add(new LabeledInputField.InputData(Messages.Patientenblatt2_civilState, "ExtInfo", "MaritalStatus", LabeledInputField.InputData.Typ.COMBO_VIEWER, (IContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                MaritalStatus ms = (MaritalStatus)element;
                if (ms != null) {
                    return ms.getLocaleText();
                }
                return super.getText(element);
            }
        }, isr, (Object)MaritalStatus.values()));
        fields.add(new LabeledInputField.InputData(Messages.Patientenblatt2_phone1, "Telefon1", LabeledInputField.InputData.Typ.STRING, null, 30));
        fields.add(new LabeledInputField.InputData(Messages.Patientenblatt2_phone2, "Telefon2", LabeledInputField.InputData.Typ.STRING, null, 30));
        fields.add(new LabeledInputField.InputData(Messages.Core_Fax, "Fax", LabeledInputField.InputData.Typ.STRING, null, 30));
        fields.add(new LabeledInputField.InputData(Messages.Core_E_Mail, "E-Mail", new LabeledInputField.IExecLinkProvider(){

            public void executeString(LabeledInputField.InputData ltf) {
                if (ltf.getText().length() == 0) {
                    return;
                }
                try {
                    URI uriMailTo = new URI("mailto", ltf.getText(), null);
                    Desktop.getDesktop().mail(uriMailTo);
                }
                catch (URISyntaxException e1) {
                    Status status = new Status(2, "ch.elexis.core.ui", "Error in using mail address " + ltf);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
                catch (IOException e2) {
                    Status status = new Status(2, "ch.elexis.core.ui", "Error in using mail address " + ltf);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
            }
        }));
        fields.add(new LabeledInputField.InputData(Messages.Core_Group, "Gruppe", LabeledInputField.InputData.Typ.STRING, null));
        fields.add(new LabeledInputField.InputData(Messages.Core_Account, "Konto", new LabeledInputField.IContentProvider(){

            public void displayContent(Object po, LabeledInputField.InputData ltf) {
                ltf.setText(Patientenblatt2.this.actPatient.getKontostand().getAmountAsString());
            }

            public void reloadContent(Object po, LabeledInputField.InputData ltf) {
                if (new AddBuchungDialog(Patientenblatt2.this.getShell(), Patientenblatt2.this.actPatient).open() == 0) {
                    ltf.setText(Patientenblatt2.this.actPatient.getKontostand().getAmountAsString());
                }
            }
        }));
        fields.add(new LabeledInputField.InputData(Messages.Core_RegularPhysiscion, "Stammarzt_", new LabeledInputField.IContentProvider(){

            public void displayContent(Object po, LabeledInputField.InputData ltf) {
                Patient p = (Patient)po;
                String result = "";
                if (p.getStammarzt() != null && p.getStammarzt().exists()) {
                    Kontakt stammarzt = p.getStammarzt();
                    if (stammarzt.istPerson()) {
                        String[] labels = stammarzt.get(true, new String[]{"Bezeichnung1", "Bezeichnung2", "Titel"});
                        result = String.valueOf(labels[2]) + " " + labels[0] + " " + labels[1];
                    } else {
                        result = stammarzt.getLabel(true);
                    }
                    String telephoneLabel = stammarzt.getTelephoneLabel();
                    String label = String.valueOf(stammarzt.getLabel()) + (telephoneLabel.length() > 0 ? " (" + telephoneLabel + ")" : "");
                    ltf.setTooltipText(label);
                } else {
                    ltf.setTooltipText(null);
                }
                ltf.setText(result);
            }

            public void reloadContent(Object po, LabeledInputField.InputData ltf) {
                if (Patientenblatt2.this.bLocked) {
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(Patientenblatt2.this.getShell(), Kontakt.class, Messages.Patientenblatt2_selectRegularPhysicianTitle, Messages.Patientenblatt2_selectRegularPhysicianMessage, false, true, new String[0]);
                ks.enableEmptyFieldButton();
                if (ks.open() == 0) {
                    Object contactSel = ks.getSelection();
                    if (contactSel == null) {
                        ((Patient)po).removeStammarzt();
                    } else {
                        Kontakt k = (Kontakt)contactSel;
                        ((Patient)po).setStammarzt(k);
                    }
                    this.displayContent(po, ltf);
                }
            }
        }));
        fields.add(new LabeledInputField.InputData(Messages.Patientenblatt2_ahvNumber, "www.ahv.ch/xid", new LabeledInputField.IContentProvider(){

            public void displayContent(Object po, LabeledInputField.InputData ltf) {
                Patient p = (Patient)po;
                ltf.setText(p.getXid("www.ahv.ch/xid"));
            }

            public void reloadContent(Object po, LabeledInputField.InputData ltf) {
                if (Patientenblatt2.this.bLocked) {
                    return;
                }
                ArrayList<String> extFlds = new ArrayList<String>();
                Kontakt k = (Kontakt)po;
                for (String dom : Xid.getXIDDomains()) {
                    Xid.XIDDomain xd = Xid.getDomain((String)dom);
                    if (k.istPerson() && xd.isDisplayedFor(Person.class) || k.istOrganisation() && xd.isDisplayedFor(Organisation.class)) {
                        extFlds.add(String.valueOf(Xid.getSimpleNameForXIDDomain((String)dom)) + "=" + dom);
                        continue;
                    }
                    if (!k.istOrganisation() || !xd.isDisplayedFor(Labor.class)) continue;
                    extFlds.add(String.valueOf(Xid.getSimpleNameForXIDDomain((String)dom)) + "=" + dom);
                }
                KontaktExtDialog dlg = new KontaktExtDialog(UiDesk.getTopShell(), (IContact)NoPoUtil.loadAsIdentifiable((PersistentObject)((Kontakt)po), IContact.class).orElse(null), extFlds.toArray(new String[0]));
                dlg.open();
                Patient p = (Patient)po;
                ltf.setText(p.getXid("www.ahv.ch/xid"));
            }
        }));
        fields.add(new LabeledInputField.InputData(Messages.Patientenblatt2_legalGuardian, "LegalGuardian", new LabeledInputField.IContentProvider(){

            public void displayContent(Object po, LabeledInputField.InputData ltf) {
                Patient p = (Patient)po;
                String guardianLabel = "";
                Kontakt legalGuardian = p.getLegalGuardian();
                if (legalGuardian != null && legalGuardian.exists()) {
                    guardianLabel = String.valueOf(legalGuardian.get("Bezeichnung1")) + " " + legalGuardian.get("Bezeichnung2");
                }
                ltf.setText(guardianLabel);
            }

            public void reloadContent(Object po, LabeledInputField.InputData ltf) {
                if (Patientenblatt2.this.bLocked) {
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(Patientenblatt2.this.getShell(), Kontakt.class, Messages.Patientenblatt2_selectLegalGuardianTitle, Messages.Patientenblatt2_selectLegalGuardianMessage, null);
                ks.enableEmptyFieldButton();
                if (ks.open() == 0) {
                    String guardianLabel = "";
                    Object contactSel = ks.getSelection();
                    Kontakt legalGuardian = null;
                    if (contactSel != null) {
                        legalGuardian = (Kontakt)contactSel;
                        guardianLabel = String.valueOf(legalGuardian.get("Bezeichnung1")) + " " + legalGuardian.get("Bezeichnung2");
                    }
                    ((Patient)po).setLegalGuardian(legalGuardian);
                    ltf.setText(guardianLabel);
                }
            }
        }));
        String[] stringArray = userfields = ConfigServiceHolder.getUser((String)CFG_EXTRAFIELDS, (String)"").split(",");
        int n = userfields.length;
        int n2 = 0;
        while (n2 < n) {
            String extfield = stringArray[n2];
            if (!StringTool.isNothing((Object)extfield)) {
                fields.add(new LabeledInputField.InputData(extfield, "ExtInfo", LabeledInputField.InputData.Typ.STRING, extfield));
            }
            ++n2;
        }
        int positionForMobileField = (fields.size() + 3) / 3;
        fields.add(positionForMobileField, new LabeledInputField.InputData(Messages.Core_Mobilephone, "Natel", LabeledInputField.InputData.Typ.STRING, null, 30));
        this.ipp = new InputPanel(this.cUserfields, 3, 3, fields.toArray(new LabeledInputField.InputData[0]));
        this.ipp.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.ipp.changed(this.ipp.getChildren());
        this.cUserfields.setBounds(this.ipp.getBounds());
        this.refresh();
        if (this.actPatient != null) {
            this.setPatient(this.actPatient);
        }
        this.layout(true);
    }

    Patientenblatt2(Composite parent, IViewSite site) {
        super(parent, 0);
        this.viewsite = site;
        this.makeActions();
        parent.setLayout((Layout)new FillLayout());
        this.setLayout((Layout)new GridLayout());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm((Composite)this);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.form.getBody().setLayout((Layout)new GridLayout());
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Patientenblatt2.this.updateExpandableLayoutWidth();
            }
        });
        this.stickerComposite = StickerComposite.createWrappedStickerComposite((Composite)this.form.getBody(), (FormToolkit)this.tk);
        this.cUserfields = new Composite(this.form.getBody(), 0);
        this.cUserfields.setLayout((Layout)new GridLayout());
        this.cUserfields.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.recreateUserpanel();
        Composite cPersonalien = this.tk.createComposite(this.form.getBody());
        cPersonalien.setLayout((Layout)new GridLayout(2, false));
        cPersonalien.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.deceasedBtn = this.tk.createButton(cPersonalien, Messages.Patient_deceased, 32);
        this.deceasedBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Patientenblatt2.this.actPatient != null) {
                    IPatient patient = (IPatient)NoPoUtil.loadAsIdentifiable((PersistentObject)Patientenblatt2.this.actPatient, IPatient.class).get();
                    patient.setDeceased(Patientenblatt2.this.deceasedBtn.getSelection());
                    CoreModelServiceHolder.get().save((Identifiable)patient);
                    if (Patientenblatt2.this.deceasedBtn.getSelection()) {
                        ((GridData)Patientenblatt2.this.deceasedDate.getLayoutData()).exclude = false;
                        Patientenblatt2.this.deceasedDate.setVisible(true);
                        Patientenblatt2.this.deceasedDate.setFocus();
                    } else {
                        ((GridData)Patientenblatt2.this.deceasedDate.getLayoutData()).exclude = true;
                        Patientenblatt2.this.deceasedDate.setVisible(false);
                    }
                    Patientenblatt2.this.refreshUi();
                }
            }
        });
        this.deceasedDate = new CDateTime(cPersonalien, 2098179);
        this.deceasedDate.setLayoutData((Object)new GridData());
        ((GridData)this.deceasedDate.getLayoutData()).exclude = false;
        this.deceasedDate.setVisible(false);
        this.deceasedDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPatient patient = (IPatient)NoPoUtil.loadAsIdentifiable((PersistentObject)Patientenblatt2.this.actPatient, IPatient.class).get();
                Date selected = Patientenblatt2.this.deceasedDate.getSelection();
                if (selected != null) {
                    patient.setDateOfDeath(LocalDateTime.ofInstant(selected.toInstant(), ZoneId.systemDefault()));
                } else {
                    patient.setDateOfDeath(null);
                }
                CoreModelServiceHolder.get().save((Identifiable)patient);
            }
        });
        this.increasedTreatmentBtn = this.tk.createButton(cPersonalien, Messages.Patientenblatt2_increasedTreatment, 32);
        this.increasedTreatmentBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Patientenblatt2.this.actPatient != null) {
                    IPatient patient = (IPatient)NoPoUtil.loadAsIdentifiable((PersistentObject)Patientenblatt2.this.actPatient, IPatient.class).get();
                    patient.setExtInfo((Object)"IncreasedTreatment", (Object)Boolean.toString(Patientenblatt2.this.increasedTreatmentBtn.getSelection()));
                    CoreModelServiceHolder.get().save((Identifiable)patient);
                }
            }
        });
        this.increasedTreatmentBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        List _buttonTabContributions = ViewContributionHelper.getFilteredAndPositionSortedContributions(this.buttonTabContributions, (int)0);
        for (IViewContribution ivc : _buttonTabContributions) {
            Composite ret = ivc.initComposite(cPersonalien);
            ret.setLayoutData((Object)new GridData(4, 128, true, false));
            this.tk.adapt(ret);
        }
        this.hHA = this.tk.createHyperlink(cPersonalien, Messages.Core_Postal_Address, 0);
        this.hHA.addHyperlinkListener((IHyperlinkListener)this.hr);
        this.hHA.setLayoutData((Object)new GridData(2));
        this.inpAdresse = this.tk.createFormText(cPersonalien, false);
        this.inpAdresse.setText("---\n", false, false);
        this.inpAdresse.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        ExpansionAdapter ecExpansionListener = new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                ExpandableComposite src = (ExpandableComposite)e.getSource();
                UserSettings.saveExpandedState((String)(Patientenblatt2.KEY_PATIENTENBLATT + src.getText()), (boolean)e.getState());
            }
        };
        List filtered = ViewContributionHelper.getFilteredAndPositionSortedContributions(this.detailComposites, (int)0);
        for (IViewContribution ivc : filtered) {
            if (ivc.getClass().getPackage().getName().startsWith("ch.elexis.core.findings.ui.viewcontributions") && ivc.isAvailable()) {
                if (ivc.getClass().getSimpleName().equals("DiagnoseViewContribution")) {
                    this.lbExpandable.remove(Messages.Core_Diagnosis);
                    this.dfExpandable.remove("Diagnosen");
                }
                if (ivc.getClass().getSimpleName().equals("PersonalAnamnesisViewContribution")) {
                    this.lbExpandable.remove(Messages.Patientenblatt2_persAnamnesisLbl);
                    this.dfExpandable.remove("PersAnamnese");
                }
                if (ivc.getClass().getSimpleName().equals("FamilyAnamnesisViewContribution")) {
                    this.lbExpandable.remove(Messages.Patientenblatt2_famAnamnesisLbl);
                    this.dfExpandable.remove("FamilienAnamnese");
                }
                if (ivc.getClass().getSimpleName().equals("RiskViewContribution")) {
                    this.lbExpandable.remove(Messages.Patientenblatt2_risksLbl);
                    this.dfExpandable.remove("Risiken");
                }
                if (ivc.getClass().getSimpleName().equals("AllergyIntoleranceViewContribution")) {
                    this.lbExpandable.remove(Messages.Allergies);
                    this.dfExpandable.remove("Allergien");
                }
            }
            ExpandableComposite ec = WidgetFactory.createExpandableComposite((FormToolkit)this.tk, (ScrolledForm)this.form, (String)ivc.getLocalizedTitle());
            ec.setLayoutData((Object)new GridData(4, 128, true, false));
            UserSettings.setExpandedState((ExpandableComposite)ec, (String)(KEY_PATIENTENBLATT + ec.getText()));
            ec.addExpansionListener((IExpansionListener)ecExpansionListener);
            Composite ret = ivc.initComposite((Composite)ec);
            if (CoreUtil.isMac() && ivc.getClass().getSimpleName().equals("DiagnoseViewContribution")) {
                this.form.getVerticalBar().addListener(13, e -> ret.redraw());
            }
            this.tk.adapt(ret);
            ec.setClient((Control)ret);
        }
        this.ecZA = WidgetFactory.createExpandableComposite((FormToolkit)this.tk, (ScrolledForm)this.form, (String)Messages.Patientenblatt2_contactForAdditionalAddress);
        UserSettings.setExpandedState((ExpandableComposite)this.ecZA, (String)Messages.Patientenblatt2_contactForAdditionalAddress);
        this.ecZA.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.inpZusatzAdresse = new ListDisplay((Composite)this.ecZA, 0, new ListDisplay.LDListener(){

            public void hyperlinkActivated(String l) {
                BezugsKontaktAuswahl bza;
                Kontakt k;
                String[] sortFields = new String[]{"Bezeichnung1", "Bezeichnung2", "Strasse"};
                KontaktSelektor ksl = new KontaktSelektor(Patientenblatt2.this.getShell(), Kontakt.class, Messages.Patientenblatt2_contactForAdditionalAddress, Messages.Patientenblatt2_pleaseSelectardress, sortFields);
                if (ksl.open() == 0 && Patientenblatt2.this.actPatient != null && (k = (Kontakt)ksl.getSelection()) != null && (bza = new BezugsKontaktAuswahl(Patientenblatt2.this.actPatient.getLabel(true), k.istPerson() ? Person.load((String)k.getId()).getLabel(true) : k.getLabel(true))).open() == 0) {
                    BezugsKontakt bk = Patientenblatt2.this.actPatient.addBezugsKontakt(k, bza.getBezugKonkaktRelation());
                    Patientenblatt2.this.inpZusatzAdresse.add((Object)bk);
                    Patientenblatt2.this.form.reflow(true);
                }
            }

            public String getLabel(Object o) {
                BezugsKontakt bezugsKontakt = (BezugsKontakt)o;
                StringBuffer sb = new StringBuffer();
                sb.append(bezugsKontakt.getLabel());
                Kontakt other = Kontakt.load((String)bezugsKontakt.get("otherID"));
                if (other.exists()) {
                    ArrayList<String> tokens = new ArrayList<String>();
                    String mobile = other.get("NatelNr");
                    String telefon1 = other.get("Telefon1");
                    String telefon2 = other.get("Telefon2");
                    String eMail = other.get("E-Mail");
                    String fax = other.get("Fax");
                    if (!StringTool.isNothing((Object)telefon1)) {
                        tokens.add("T1: " + telefon1);
                    }
                    if (!StringTool.isNothing((Object)telefon2)) {
                        tokens.add("T2: " + telefon2);
                    }
                    if (!StringTool.isNothing((Object)mobile)) {
                        tokens.add("M: " + mobile);
                    }
                    if (!StringTool.isNothing((Object)fax)) {
                        tokens.add("F: " + fax);
                    }
                    if (!StringTool.isNothing((Object)eMail)) {
                        tokens.add(eMail);
                    }
                    for (String token : tokens) {
                        sb.append(", ");
                        sb.append(token);
                    }
                    return sb.toString();
                }
                return "?";
            }
        });
        this.inpZusatzAdresse.addHyperlinks(new String[]{Messages.Core_Add});
        this.inpZusatzAdresse.setMenu(new IAction[]{this.removeZAAction, this.showZAAction, this.showBKAction, this.copySelectedContactInfosToClipboardAction, this.copySelectedAddressesToClipboardAction});
        this.ecZA.setClient(this.inpZusatzAdresse);
        this.compAdditionalAddresses = WidgetFactory.createExpandableComposite((FormToolkit)this.tk, (ScrolledForm)this.form, (String)Messages.Patientenblatt2_additionalAdresses);
        this.compAdditionalAddresses.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.additionalAddresses = new ListDisplay((Composite)this.compAdditionalAddresses, 0, new ListDisplay.LDListener(){

            public void hyperlinkActivated(String l) {
                ZusatzAdresseEingabeDialog aed;
                if (Patientenblatt2.this.actPatient != null && (aed = new ZusatzAdresseEingabeDialog(Patientenblatt2.this.form.getShell(), (Kontakt)Patientenblatt2.this.actPatient)).open() == 0) {
                    Patientenblatt2.this.additionalAddresses.add((Object)aed.getZusatzAdresse());
                    Patientenblatt2.this.form.reflow(true);
                }
            }

            public String getLabel(Object o) {
                ZusatzAdresse address = (ZusatzAdresse)o;
                if (address != null) {
                    return address.getLabel();
                }
                return "?";
            }
        });
        this.additionalAddresses.addHyperlinks(new String[]{Messages.Core_Add});
        this.makeAdditionalAddressActions();
        this.additionalAddresses.setMenu(new IAction[]{this.removeAdditionalAddressAction, this.showAdditionalAddressAction});
        this.compAdditionalAddresses.setClient(this.additionalAddresses);
        int i = 0;
        while (i < this.lbExpandable.size()) {
            this.ec.add(WidgetFactory.createExpandableComposite((FormToolkit)this.tk, (ScrolledForm)this.form, (String)this.lbExpandable.get(i)));
            UserSettings.setExpandedState((ExpandableComposite)this.ec.get(i), (String)(KEY_PATIENTENBLATT + this.lbExpandable.get(i)));
            final Text text = this.tk.createText((Composite)this.ec.get(i), "", 66);
            FilterNonPrintableModifyListener.addTo((Text)text);
            text.setData("index", (Object)i);
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    Patientenblatt2.this.saveExpandable((Integer)text.getData("index"));
                }
            });
            this.txExpandable.add(text);
            this.ec.get(i).setData(KEY_DBFIELD, (Object)this.dfExpandable.get(i));
            this.ec.get(i).addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    Text tx;
                    ExpandableComposite src = (ExpandableComposite)e.getSource();
                    if (e.getState()) {
                        Text tx2 = (Text)src.getClient();
                        if (Patientenblatt2.this.actPatient != null) {
                            tx2.setText(StringTool.unNull((String)Patientenblatt2.this.actPatient.get((String)src.getData(Patientenblatt2.KEY_DBFIELD))));
                        } else {
                            tx2.setText("");
                        }
                    } else if (Patientenblatt2.this.actPatient != null && (tx = (Text)src.getClient()).getText() != null) {
                        Patientenblatt2.this.actPatient.set((String)src.getData(Patientenblatt2.KEY_DBFIELD), tx.getText());
                    }
                    UserSettings.saveExpandedState((String)(Patientenblatt2.KEY_PATIENTENBLATT + src.getText()), (boolean)e.getState());
                }
            });
            this.txExpandable.get(i).addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    Text tx = (Text)e.getSource();
                    tx.redraw();
                    Patientenblatt2.this.form.getBody().layout(true);
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            this.ec.get(i).setClient((Control)this.txExpandable.get(i));
            ++i;
        }
        this.ecdm = WidgetFactory.createExpandableComposite((FormToolkit)this.tk, (ScrolledForm)this.form, (String)FIXMEDIKATION);
        UserSettings.setExpandedState((ExpandableComposite)this.ecdm, (String)(KEY_PATIENTENBLATT + FIXMEDIKATION));
        this.ecdm.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.dmd = new FixMediDisplay((Composite)this.ecdm, site);
        this.ecdm.setClient((Control)this.dmd);
        List lContrib = ViewContributionHelper.getFilteredAndPositionSortedContributions(this.detailComposites, (int)1);
        for (IViewContribution ivc : lContrib) {
            ExpandableComposite ec = WidgetFactory.createExpandableComposite((FormToolkit)this.tk, (ScrolledForm)this.form, (String)ivc.getLocalizedTitle());
            ec.setLayoutData((Object)new GridData(4, 128, true, false));
            UserSettings.setExpandedState((ExpandableComposite)ec, (String)(KEY_PATIENTENBLATT + ec.getText()));
            ec.addExpansionListener((IExpansionListener)ecExpansionListener);
            Composite ret = ivc.initComposite((Composite)ec);
            this.tk.adapt(ret);
            ec.setClient((Control)ret);
        }
        this.viewmenu = new ViewMenus(this.viewsite);
        this.viewmenu.createMenu(new IAction[]{GlobalActions.printEtikette, GlobalActions.printAdresse, GlobalActions.printBlatt, GlobalActions.showBlatt, GlobalActions.printRoeBlatt, this.copySelectedContactInfosToClipboardAction, this.copySelectedAddressesToClipboardAction});
        this.viewmenu.createToolbar(new IAction[]{this.copySelectedContactInfosToClipboardAction});
        this.viewmenu.createToolbar(new IAction[]{this.copySelectedAddressesToClipboardAction});
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat_sync, this.eeli_pat, this.eeli_user});
        this.tk.paintBordersFor(this.form.getBody());
    }

    protected void save() {
        if (this.actPatient != null && this.ipp != null) {
            this.ipp.save();
        }
    }

    protected void saveExpandable(Integer i) {
        if (i != null) {
            String field = this.dfExpandable.get(i);
            String oldvalue = StringTool.unNull((String)this.actPatient.get(field));
            String newvalue = this.txExpandable.get(i).getText();
            if (this.bLocked) {
                this.txExpandable.get(i).setText(oldvalue);
            } else {
                this.actPatient.set(field, newvalue);
            }
        }
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat_sync, this.eeli_pat, this.eeli_user});
        super.dispose();
    }

    public void setPatient(Patient p) {
        this.actPatient = p;
        this.refreshUi();
        this.setUnlocked(LocalLockServiceHolder.get().isLockedLocal((Object)p));
    }

    public void refreshUi() {
        this.ipp.getAutoForm().reload((PersistentObject)this.actPatient);
        this.detailComposites.forEach(dc -> dc.setDetailObject((Object)this.actPatient, null));
        this.buttonTabContributions.forEach(dc -> dc.setDetailObject((Object)this.actPatient, null));
        if (this.actPatient == null) {
            this.form.setText(Messages.Core_No_patient_selected);
            this.inpAdresse.setText("", false, false);
            this.deceasedBtn.setSelection(false);
            this.increasedTreatmentBtn.setSelection(false);
            this.inpZusatzAdresse.clear();
            this.setUnlocked(false);
            return;
        }
        IPatient patient = (IPatient)NoPoUtil.loadAsIdentifiable((PersistentObject)this.actPatient, IPatient.class).get();
        this.deceasedBtn.setSelection(patient.isDeceased());
        if (patient.getExtInfo((Object)"IncreasedTreatment") instanceof String) {
            this.increasedTreatmentBtn.setSelection(Boolean.parseBoolean((String)patient.getExtInfo((Object)"IncreasedTreatment")));
        } else {
            this.increasedTreatmentBtn.setSelection(false);
        }
        if (patient.isDeceased()) {
            if (patient.getDateOfDeath() != null) {
                this.deceasedDate.setSelection(Date.from(patient.getDateOfDeath().atZone(ZoneId.systemDefault()).toInstant()));
            } else {
                this.deceasedDate.setSelection(null);
            }
            ((GridData)this.deceasedDate.getLayoutData()).exclude = false;
            this.deceasedDate.setVisible(true);
        } else {
            this.deceasedDate.setSelection(null);
            ((GridData)this.deceasedDate.getLayoutData()).exclude = true;
            this.deceasedDate.setVisible(false);
        }
        this.stickerComposite.setPatient((IPatient)CoreModelServiceHolder.get().load(this.actPatient.getId(), IPatient.class).orElse(null));
        this.form.setText(String.valueOf(StringTool.unNull((String)this.actPatient.getName())) + " " + StringTool.unNull((String)this.actPatient.getVorname()) + " (" + this.actPatient.getPatCode() + ")");
        this.inpAdresse.setText(this.actPatient.getPostAnschrift(false), false, false);
        UserSettings.setExpandedState((ExpandableComposite)this.ecZA, (String)"Patientenblatt/Zusatzadressen");
        this.inpZusatzAdresse.clear();
        for (BezugsKontakt za : this.actPatient.getBezugsKontakte()) {
            this.inpZusatzAdresse.add((Object)za);
        }
        this.additionalAddresses.clear();
        for (ZusatzAdresse zusatzAdresse : this.actPatient.getZusatzAdressen()) {
            this.additionalAddresses.add((Object)zusatzAdresse);
        }
        int i = 0;
        while (i < this.dfExpandable.size()) {
            UserSettings.setExpandedState((ExpandableComposite)this.ec.get(i), (String)(KEY_PATIENTENBLATT + this.ec.get(i).getText()));
            this.txExpandable.get(i).setText(StringTool.unNull((String)this.actPatient.get(this.dfExpandable.get(i))));
            ++i;
        }
        this.dmd.reload();
        this.updateExpandableLayoutWidth();
        this.refresh();
    }

    public void refresh() {
        this.form.reflow(true);
    }

    private void makeAdditionalAddressActions() {
        this.removeAdditionalAddressAction = new Action(Messages.Patientenblatt2_removeAddress){

            public void run() {
                if (!Patientenblatt2.this.bLocked) {
                    ZusatzAdresse a = (ZusatzAdresse)Patientenblatt2.this.additionalAddresses.getSelection();
                    a.delete();
                    Patientenblatt2.this.setPatient(Patientenblatt2.this.actPatient);
                }
            }
        };
        this.showAdditionalAddressAction = new Action(Messages.Patientenblatt2_showAddress){

            public void run() {
                ZusatzAdresse zusatzAdresse = (ZusatzAdresse)Patientenblatt2.this.additionalAddresses.getSelection();
                ZusatzAdresseEingabeDialog aed = new ZusatzAdresseEingabeDialog(Patientenblatt2.this.form.getShell(), (Kontakt)Patientenblatt2.this.actPatient, zusatzAdresse, Patientenblatt2.this.bLocked);
                if (aed.open() == 0) {
                    Patientenblatt2.this.setPatient(Patientenblatt2.this.actPatient);
                }
            }
        };
    }

    private void makeActions() {
        this.removeZAAction = new Action(Messages.Patientenblatt2_removeAddress){

            public void run() {
                if (!Patientenblatt2.this.bLocked) {
                    BezugsKontakt a = (BezugsKontakt)Patientenblatt2.this.inpZusatzAdresse.getSelection();
                    a.delete();
                    Patientenblatt2.this.setPatient(Patientenblatt2.this.actPatient);
                }
            }
        };
        this.showZAAction = new RestrictedAction(AccessControlDefaults.PATIENT_DISPLAY, Messages.Patientenblatt2_showAddress){

            public void doRun() {
                Kontakt a = Kontakt.load((String)((BezugsKontakt)Patientenblatt2.this.inpZusatzAdresse.getSelection()).get("otherID"));
                KontaktDetailDialog kdd = new KontaktDetailDialog(Patientenblatt2.this.form.getShell(), a, Patientenblatt2.this.bLocked);
                if (kdd.open() == 0) {
                    Patientenblatt2.this.setPatient(Patientenblatt2.this.actPatient);
                }
            }
        };
        this.showBKAction = new RestrictedAction(AccessControlDefaults.PATIENT_DISPLAY, Messages.Patientenblatt2_showBezugKontaktRelation){

            public void doRun() {
                BezugsKontakt bezugsKontakt = (BezugsKontakt)Patientenblatt2.this.inpZusatzAdresse.getSelection();
                if (bezugsKontakt != null) {
                    Kontakt k = Kontakt.load((String)bezugsKontakt.get("otherID"));
                    BezugsKontaktAuswahl bza = new BezugsKontaktAuswahl(Patientenblatt2.this.actPatient.getLabel(true), k.istPerson() ? Person.load((String)k.getId()).getLabel(true) : k.getLabel(true), bezugsKontakt, Patientenblatt2.this.bLocked);
                    if (bezugsKontakt != null && bza.open() == 0 && bza.getBezugKonkaktRelation() != null) {
                        bezugsKontakt.updateRelation(bza.getBezugKonkaktRelation());
                        Patientenblatt2.this.setPatient(Patientenblatt2.this.actPatient);
                    }
                }
            }
        };
        this.copySelectedContactInfosToClipboardAction = new Action(Messages.KontakteView_copySelectedContactInfosToClipboard){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.KontakteView_copySelectedContactInfosToClipboard);
            }

            public void run() {
                StringBuffer SelectedContactInfosText = new StringBuffer();
                BezugsKontakt sel = (BezugsKontakt)Patientenblatt2.this.inpZusatzAdresse.getSelection();
                if (sel != null) {
                    String thisAddressFLD_E_MAIL;
                    String thisAddressFLD_FAX;
                    String thisAddressFLD_PHONE2;
                    String thisAddressFLD_PHONE1;
                    String thisAddressFLD_MOBILEPHONE;
                    String thisAddressFLD_PLACE;
                    String thisAddressFLD_ZIP;
                    String thisAddressFLD_COUNTRY;
                    String thisAddressFLD_STREET;
                    Kontakt k = sel.getBezugsKontakt();
                    if (k.istPerson()) {
                        String thisPatientBIRTHDATE;
                        String thisPersonFLD_NAME3;
                        String thisPersonFLD_REMARK;
                        String titel;
                        Person p = Person.load((String)k.getId());
                        String salutation = p.getGeschlecht().equals("m") ? Messages.Contact_SalutationM : (p.getGeschlecht().equals("w") ? Messages.Contact_SalutationF : "");
                        if (!StringTool.isNothing((Object)salutation)) {
                            SelectedContactInfosText.append(salutation);
                            SelectedContactInfosText.append(" ");
                        }
                        if (!StringTool.isNothing((Object)(titel = p.get("Titel")))) {
                            SelectedContactInfosText.append(titel).append(" ");
                        }
                        if (!StringTool.isNothing((Object)p.getVorname())) {
                            SelectedContactInfosText.append(String.valueOf(p.getVorname()) + " ");
                        }
                        if (!StringTool.isNothing((Object)p.getName())) {
                            SelectedContactInfosText.append(p.getName());
                        }
                        if (!StringTool.isNothing((Object)(thisPersonFLD_REMARK = p.get("Bemerkung")))) {
                            SelectedContactInfosText.append(",").append(" ").append(thisPersonFLD_REMARK);
                        }
                        if (!StringTool.isNothing((Object)(thisPersonFLD_NAME3 = p.get("Bezeichnung3")))) {
                            SelectedContactInfosText.append(",").append(" ").append(thisPersonFLD_NAME3);
                        }
                        if (!StringTool.isNothing((Object)(thisPatientBIRTHDATE = p.get("Geburtsdatum")))) {
                            SelectedContactInfosText.append(", " + new TimeTool(thisPatientBIRTHDATE).toString(4));
                        }
                    } else {
                        String thisAddressFLD_NAME1 = k.get("Bezeichnung1");
                        String thisAddressFLD_NAME2 = k.get("Bezeichnung2");
                        String thisAddressFLD_NAME3 = k.get("Bezeichnung3");
                        if (!StringTool.isNothing((Object)thisAddressFLD_NAME1)) {
                            SelectedContactInfosText.append(thisAddressFLD_NAME1);
                            if (!StringTool.isNothing((Object)(String.valueOf(thisAddressFLD_NAME2) + thisAddressFLD_NAME3))) {
                                SelectedContactInfosText.append(" ");
                            }
                        }
                        if (!StringTool.isNothing((Object)thisAddressFLD_NAME2)) {
                            SelectedContactInfosText.append(thisAddressFLD_NAME2);
                        }
                        if (!StringTool.isNothing((Object)thisAddressFLD_NAME3)) {
                            SelectedContactInfosText.append(thisAddressFLD_NAME3);
                        }
                        if (!StringTool.isNothing((Object)thisAddressFLD_NAME3)) {
                            SelectedContactInfosText.append(" ");
                        }
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_STREET = k.get("Strasse")))) {
                        SelectedContactInfosText.append(", " + thisAddressFLD_STREET);
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_COUNTRY = k.get("Land")))) {
                        SelectedContactInfosText.append(", " + thisAddressFLD_COUNTRY + "-");
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_ZIP = k.get("Plz")))) {
                        if (StringTool.isNothing((Object)thisAddressFLD_COUNTRY)) {
                            SelectedContactInfosText.append(", ");
                        }
                        SelectedContactInfosText.append(thisAddressFLD_ZIP);
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_PLACE = k.get("Ort")))) {
                        if (StringTool.isNothing((Object)thisAddressFLD_COUNTRY) && StringTool.isNothing((Object)thisAddressFLD_ZIP)) {
                            SelectedContactInfosText.append(",");
                        }
                        SelectedContactInfosText.append(" " + thisAddressFLD_PLACE);
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_MOBILEPHONE = k.get("NatelNr")))) {
                        SelectedContactInfosText.append(", " + "NatelNr" + " " + thisAddressFLD_MOBILEPHONE);
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_PHONE1 = k.get("Telefon1")))) {
                        SelectedContactInfosText.append(",  " + thisAddressFLD_PHONE1);
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_PHONE2 = k.get("Telefon2")))) {
                        SelectedContactInfosText.append(",  " + thisAddressFLD_PHONE2);
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_FAX = k.get("Fax")))) {
                        SelectedContactInfosText.append(", " + "Fax" + " " + thisAddressFLD_FAX);
                    }
                    if (!StringTool.isNothing((Object)(thisAddressFLD_E_MAIL = k.get("E-Mail")))) {
                        SelectedContactInfosText.append(", " + thisAddressFLD_E_MAIL);
                    }
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{SelectedContactInfosText.toString()};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
        this.copySelectedAddressesToClipboardAction = new Action(Messages.KontakteView_copySelectedAddressesToClipboard){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.KontakteView_copySelectedAddressesToClipboard);
            }

            public void run() {
                StringBuffer selectedAddressesText = new StringBuffer();
                BezugsKontakt sel = (BezugsKontakt)Patientenblatt2.this.inpZusatzAdresse.getSelection();
                if (sel != null) {
                    Kontakt k = sel.getBezugsKontakt();
                    selectedAddressesText.append(k.getPostAnschriftPhoneFaxEmail(true, true));
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{selectedAddressesText.toString()};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
    }

    private void updateExpandableLayoutWidth() {
        if (this.ec != null && this.form != null && !this.form.isDisposed()) {
            for (ExpandableComposite expandable : this.ec) {
                if (!(expandable.getLayoutData() instanceof GridData)) continue;
                ((GridData)expandable.getLayoutData()).widthHint = this.getClientArea().width > 50 ? this.getClientArea().width : -1;
            }
            this.form.getBody().layout(true);
        }
    }

    public void setUnlocked(boolean unlocked) {
        for (ExpandableComposite ex : this.ec) {
            ex.getClient().setEnabled(unlocked);
        }
        this.detailComposites.forEach(dc -> dc.setUnlocked(unlocked));
        this.bLocked = !unlocked;
        this.ipp.setUnlocked(unlocked);
        this.inpZusatzAdresse.setUnlocked(unlocked);
        this.hHA.setEnabled(unlocked);
        this.removeZAAction.setEnabled(unlocked);
        this.removeAdditionalAddressAction.setEnabled(unlocked);
        this.additionalAddresses.setUnlocked(unlocked);
        this.dmd.setUnlocked(unlocked);
        if (unlocked) {
            this.hHA.setForeground(UiDesk.getColor((String)"blau"));
        } else {
            this.hHA.setForeground(UiDesk.getColor((String)"grau"));
        }
    }

    class Hyperlinkreact
    extends HyperlinkAdapter {
        Hyperlinkreact() {
        }

        public void linkActivated(HyperlinkEvent e) {
            if (Patientenblatt2.this.actPatient != null) {
                AnschriftEingabeDialog aed = new AnschriftEingabeDialog(Patientenblatt2.this.form.getShell(), (Kontakt)Patientenblatt2.this.actPatient);
                aed.open();
                Patientenblatt2.this.inpAdresse.setText(Patientenblatt2.this.actPatient.getPostAnschrift(false), false, false);
            }
        }
    }
}

