/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.LocalizeUtil;
import ch.elexis.core.types.RelationshipType;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.BezugsKontaktRelation;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BezugsKontaktAuswahl
extends Dialog {
    Combo cbBezugSrc;
    Combo cbTypeSrc;
    Combo cbTypeDest;
    Map<String, BezugsKontaktRelation> mapBezugKonktatRelation = new HashMap<String, BezugsKontaktRelation>();
    BezugsKontaktRelation selectedBezugKontaktRelation = new BezugsKontaktRelation();
    String srcLabel;
    String destLabel;
    Composite dynComposite;
    BezugsKontakt bezugsKontakt;
    private boolean locked = false;

    public BezugsKontaktAuswahl(String destLabel, String srcLabel) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.srcLabel = srcLabel;
        this.destLabel = destLabel;
    }

    public BezugsKontaktAuswahl(String destLabel, String srcLabel, BezugsKontakt bezugsKontakt, boolean locked) {
        this(destLabel, srcLabel);
        this.bezugsKontakt = bezugsKontakt;
        this.locked = locked;
    }

    public void create() {
        Button btnOk;
        super.create();
        this.getShell().setText(Messages.Patientenblatt2_kindOfRelation);
        if (this.locked && (btnOk = this.getButton(0)) != null) {
            btnOk.setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = (Composite)super.createDialogArea(parent);
        new Label(ret, 0).setText(Messages.Patientenblatt2_pleaseEnterKindOfRelationship);
        new Label(ret, 0).setText(String.valueOf(this.srcLabel) + " " + Messages.Bezugskontakt_Is);
        this.cbBezugSrc = new Combo(ret, 0);
        this.cbBezugSrc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String bez = ConfigServiceHolder.getGlobal((String)"views/patientenblatt/Bezugskontakttypen", (String)"");
        String[] items = this.getBezugKonkaktTypes(bez);
        this.cbBezugSrc.setItems(items);
        this.cbBezugSrc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BezugsKontaktAuswahl.this.reCalc(true);
            }
        });
        this.cbBezugSrc.setEnabled(!this.locked);
        if (this.bezugsKontakt != null && this.bezugsKontakt.exists()) {
            this.cbBezugSrc.setText(this.bezugsKontakt.getBezug());
            this.mapBezugKonktatRelation.put(this.bezugsKontakt.getBezug(), new BezugsKontaktRelation(this.bezugsKontakt));
        }
        final GridData data = new GridData(4, 0x1000000, true, true, 1, 1);
        final Button btn = new Button(ret, 2);
        btn.setText("+ " + Messages.BezugsKonktat_FormalerReference);
        btn.setLayoutData((Object)new GridData(131072, 128, true, true, 1, 1));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                data.exclude = !data.exclude;
                BezugsKontaktAuswahl.this.dynComposite.setVisible(!data.exclude);
                BezugsKontaktAuswahl.this.dynComposite.getShell().pack();
                if (BezugsKontaktAuswahl.this.dynComposite.isVisible()) {
                    btn.setText("- " + Messages.BezugsKonktat_FormalerReference);
                    BezugsKontaktAuswahl.this.reCalc(true);
                } else {
                    btn.setText("+ " + Messages.BezugsKonktat_FormalerReference);
                }
            }
        });
        this.dynComposite = new Composite(ret, 2048);
        this.dynComposite.setLayout((Layout)new GridLayout());
        this.dynComposite.setLayoutData((Object)data);
        this.dynComposite.setVisible(false);
        data.exclude = true;
        String[] bezugKontaktTypes = BezugsKontaktAuswahl.getBezugKontaktTypes();
        new Label(this.dynComposite, 0).setText(String.valueOf(Messages.Bezugskontakt_RelationFrom) + " ");
        this.cbTypeDest = new Combo(this.dynComposite, 8);
        this.cbTypeDest.setEnabled(!this.locked);
        this.cbTypeDest.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbTypeDest.setItems(bezugKontaktTypes);
        new Label(this.dynComposite, 0).setText(String.valueOf(Messages.Bezugskontakt_RelationTo) + " ");
        this.cbTypeSrc = new Combo(this.dynComposite, 8);
        this.cbTypeSrc.setEnabled(!this.locked);
        this.cbTypeSrc.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbTypeSrc.setItems(bezugKontaktTypes);
        this.reCalc(true);
        return ret;
    }

    public static String[] getBezugKontaktTypes() {
        RelationshipType[] allRelationshipTypes = RelationshipType.values();
        String[] displayValues = new String[allRelationshipTypes.length];
        int idx = 0;
        RelationshipType[] relationshipTypeArray = allRelationshipTypes;
        int n = allRelationshipTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RelationshipType relationshipType = relationshipTypeArray[n2];
            displayValues[idx++] = LocalizeUtil.getLocaleText((Enumerator)relationshipType);
            ++n2;
        }
        return displayValues;
    }

    private String[] getBezugKonkaktTypes(String cfgBezugKonktaks) {
        String[] stringArray = cfgBezugKonktaks.split("#!>");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cfgPart = stringArray[n2];
            BezugsKontaktRelation bezugsKontaktRelation = new BezugsKontaktRelation();
            bezugsKontaktRelation.loadValuesByCfg(cfgPart);
            this.mapBezugKonktatRelation.put(bezugsKontaktRelation.getName(), bezugsKontaktRelation);
            ++n2;
        }
        ArrayList<String> keys = new ArrayList<String>(this.mapBezugKonktatRelation.keySet());
        Collections.sort(keys);
        return keys.toArray(new String[0]);
    }

    public void reCalc(boolean autoSelect) {
        BezugsKontaktRelation bezugsKontaktType;
        this.selectedBezugKontaktRelation = bezugsKontaktType = this.mapBezugKonktatRelation.get(this.cbBezugSrc.getText());
        if (this.selectedBezugKontaktRelation == null) {
            this.selectedBezugKontaktRelation = new BezugsKontaktRelation(this.cbBezugSrc.getText(), RelationshipType.AGENERIC, RelationshipType.AGENERIC);
        }
        if (this.selectedBezugKontaktRelation.getDestRelationType() == null) {
            this.selectedBezugKontaktRelation.setDestRelationType(RelationshipType.AGENERIC);
        }
        if (this.selectedBezugKontaktRelation.getSrcRelationType() == null) {
            this.selectedBezugKontaktRelation.setSrcRelationType(RelationshipType.AGENERIC);
        }
        if (autoSelect) {
            this.cbTypeSrc.setText(LocalizeUtil.getLocaleText((Enumerator)this.selectedBezugKontaktRelation.getSrcRelationType()));
            this.cbTypeDest.setText(LocalizeUtil.getLocaleText((Enumerator)this.selectedBezugKontaktRelation.getDestRelationType()));
        }
    }

    protected void okPressed() {
        String nitem;
        String[] items;
        this.reCalc(false);
        int selIdx = this.cbTypeDest.getSelectionIndex();
        if (selIdx != -1) {
            this.selectedBezugKontaktRelation.setDestRelationType(RelationshipType.values()[selIdx]);
        }
        if ((selIdx = this.cbTypeSrc.getSelectionIndex()) != -1) {
            this.selectedBezugKontaktRelation.setSrcRelationType(RelationshipType.values()[selIdx]);
        }
        if (StringTool.getIndex((String[])(items = this.cbBezugSrc.getItems()), (String)(nitem = this.selectedBezugKontaktRelation.getName())) == -1) {
            String res = String.valueOf(ConfigServiceHolder.getGlobal((String)"views/patientenblatt/Bezugskontakttypen", (String)"")) + "#!>" + this.selectedBezugKontaktRelation.getCfgString();
            ConfigServiceHolder.setGlobal((String)"views/patientenblatt/Bezugskontakttypen", (String)res);
        }
        super.okPressed();
    }

    public BezugsKontaktRelation getBezugKonkaktRelation() {
        return this.selectedBezugKontaktRelation;
    }
}

