/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.controls;

import ch.elexis.core.model.IContact;
import ch.elexis.core.types.ContactGender;
import ch.elexis.core.types.Country;
import ch.elexis.core.ui.contacts.controls.AbstractComposite;
import ch.elexis.core.ui.contacts.proposalProvider.CityInformationProposalProvider;
import ch.elexis.core.ui.contacts.proposalProvider.ContactGeonames;
import ch.elexis.core.ui.contacts.proposalProvider.StreetInformationProposalProvider;
import ch.elexis.core.ui.contacts.proposalProvider.TitleProposalProvider;
import ch.elexis.core.ui.contacts.proposalProvider.ZipInformationProposalProvider;
import ch.elexis.core.ui.contacts.views.provider.ContactSelectorObservableMapLabelProvider;
import ch.elexis.core.ui.contacts.views.provider.TableDecoratingLabelProvider;
import ch.elexis.core.ui.icons.Images;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StammDatenComposite
extends AbstractComposite {
    private static Logger log = LoggerFactory.getLogger(StammDatenComposite.class);
    private IContact contact;
    private Label lblHeadline;
    private Label lblContactType;
    private Text txtTitleFront;
    private GridData gd_txtTitleFront;
    private Text txtFirstName;
    private Text txtFamilyName;
    private Text txtTitleBack;
    private GridData gd_txtTitleBack;
    private GridData gd_comboSex;
    private Text txtZIP;
    private ZipInformationProposalProvider zipIP = new ZipInformationProposalProvider();
    private Text txtCity;
    private CityInformationProposalProvider cityIP = new CityInformationProposalProvider();
    private Text txtStreet;
    private StreetInformationProposalProvider streetIP = new StreetInformationProposalProvider();
    private Text txtTelefon;
    private Text txtTelefon2;
    private Text txtMobil;
    private Text txtFax;
    private Text txtEmail;
    private Text txtWebsite;
    private Text txtNotes;
    private ComboViewer comboViewerCountry;
    private DateTime dateTimeDob;
    private GridData gd_dateTimeDob;
    private Composite compositeHeader;
    private ComboViewer comboViewerSex;
    private TabbedPropertySheetWidgetFactory tpsf = null;
    public static final String PERSON_LABEL = "Vollst\u00e4ndiger Name, Geschlecht, Geburtsdatum";
    public static final String ORGANIZATION_LABEL = "Bezeichnung, Zusatz";
    private Label lblCode;
    private ILabelDecorator decorator;
    private TableDecoratingLabelProvider tdlp;
    FocusListener preDialFocuListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            Text text = (Text)e.widget;
            if (text.getText().equalsIgnoreCase(ContactGeonames.getDialPrefix())) {
                text.setText("");
            }
        }

        public void focusGained(FocusEvent e) {
            Text text = (Text)e.widget;
            if (text.getText().length() == 0) {
                text.setText(ContactGeonames.getDialPrefix());
            }
        }
    };
    private Button btnWebsite;
    private Button btnEmail;

    public StammDatenComposite(Composite parent, int style, TabbedPropertySheetPage tpsp) {
        this(parent, style);
        this.tpsf = tpsp.getWidgetFactory();
        if (this.tpsf != null) {
            this.tpsf.adapt(this.compositeHeader);
            this.tpsf.paintBordersFor(this.compositeHeader);
            this.tpsf.adapt((Control)this.lblContactType, true, false);
            this.tpsf.adapt((Control)this.lblHeadline, true, false);
            this.tpsf.adapt((Control)this.lblCode, true, true);
            this.tpsf.adapt((Composite)this.comboViewerSex.getCombo());
            this.tpsf.paintBordersFor((Composite)this.comboViewerSex.getCombo());
            this.tpsf.paintBordersFor((Composite)this.dateTimeDob);
            this.tpsf.adapt((Composite)this.dateTimeDob);
            this.tpsf.adapt((Composite)this.comboViewerCountry.getCombo());
            this.tpsf.paintBordersFor((Composite)this.comboViewerCountry.getCombo());
            this.tpsf.adapt((Control)this.btnEmail, true, true);
            this.tpsf.adapt((Control)this.btnWebsite, true, true);
            this.tpsf.adapt((Control)this.txtNotes, true, true);
        }
    }

    public StammDatenComposite(Composite parent, int style) {
        super(parent, style);
        this.decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.tdlp = new TableDecoratingLabelProvider((ILabelProvider)new ContactSelectorObservableMapLabelProvider((IObservableMap[])new ObservableMap[0]), this.decorator);
        this.setLayout((Layout)new GridLayout(6, false));
        this.compositeHeader = new Composite((Composite)this, 0);
        this.compositeHeader.setLayoutData((Object)new GridData(4, 4, false, false, 6, 1));
        this.compositeHeader.setLayout((Layout)new GridLayout(3, false));
        this.lblContactType = new Label(this.compositeHeader, 0);
        this.lblHeadline = new Label(this.compositeHeader, 0);
        this.lblHeadline.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblCode = new Label(this.compositeHeader, 0);
        GridData gd_lblCode = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblCode.widthHint = 40;
        this.lblCode.setLayoutData((Object)gd_lblCode);
        this.txtTitleFront = new Text((Composite)this, 2048);
        this.gd_txtTitleFront = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.gd_txtTitleFront.widthHint = 60;
        this.txtTitleFront.setLayoutData((Object)this.gd_txtTitleFront);
        this.txtTitleFront.setMessage("Titel");
        ContentProposalAdapter cpaTitleFront = new ContentProposalAdapter((Control)this.txtTitleFront, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TitleProposalProvider(1), null, null);
        cpaTitleFront.setProposalAcceptanceStyle(2);
        this.txtFirstName = new Text((Composite)this, 2048);
        this.txtFirstName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFamilyName = new Text((Composite)this, 2048);
        this.txtFamilyName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtTitleBack = new Text((Composite)this, 2048);
        this.gd_txtTitleBack = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.gd_txtTitleBack.widthHint = 60;
        this.txtTitleBack.setLayoutData((Object)this.gd_txtTitleBack);
        this.txtTitleBack.setMessage("Titel");
        ContentProposalAdapter cpaTitleBack = new ContentProposalAdapter((Control)this.txtTitleBack, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TitleProposalProvider(2), null, null);
        cpaTitleBack.setProposalAcceptanceStyle(2);
        this.comboViewerSex = new ComboViewer((Composite)this, 0);
        this.gd_comboSex = new GridData(4, 0x1000000, false, false, 1, 1);
        this.comboViewerSex.getCombo().setLayoutData((Object)this.gd_comboSex);
        this.comboViewerSex.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerSex.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                switch ((ContactGender)element) {
                    case FEMALE: {
                        return "W";
                    }
                    case MALE: {
                        return "M";
                    }
                    case UNDEFINED: {
                        return "X";
                    }
                }
                return "?";
            }
        });
        this.comboViewerSex.setInput((Object)ContactGender.values());
        this.dateTimeDob = new DateTime((Composite)this, 0x10000800);
        this.gd_dateTimeDob = new GridData(4, 0x1000000, false, false, 1, 1);
        this.dateTimeDob.setLayoutData((Object)this.gd_dateTimeDob);
        Group grpAddress = new Group((Composite)this, 0);
        grpAddress.setLayout((Layout)new GridLayout(3, false));
        grpAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        grpAddress.setText("Adresse");
        this.comboViewerCountry = new ComboViewer((Composite)grpAddress, 0);
        GridData gd_combo_1 = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_combo_1.widthHint = 55;
        this.comboViewerCountry.getCombo().setLayoutData((Object)gd_combo_1);
        this.comboViewerCountry.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerCountry.setInput((Object)Country.values());
        this.comboViewerCountry.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Country selCountry = (Country)((StructuredSelection)event.getSelection()).getFirstElement();
                if (selCountry == Country.NDF) {
                    StammDatenComposite.this.comboViewerCountry.getCombo().setForeground(Display.getCurrent().getSystemColor(3));
                    ContactGeonames.setCountry(null);
                } else {
                    StammDatenComposite.this.comboViewerCountry.getCombo().setForeground(Display.getCurrent().getSystemColor(2));
                    ContactGeonames.setCountry(selCountry);
                }
            }
        });
        this.txtCity = new Text((Composite)grpAddress, 2048);
        this.txtCity.setMessage("Ortschaft");
        this.txtCity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ContentProposalAdapter cpaCity = new ContentProposalAdapter((Control)this.txtCity, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.cityIP, null, null);
        cpaCity.setProposalAcceptanceStyle(2);
        cpaCity.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                StammDatenComposite.this.txtZIP.setText(StammDatenComposite.this.cityIP.findZipForCityName(proposal.getContent()));
            }
        });
        this.txtZIP = new Text((Composite)grpAddress, 2048);
        this.txtZIP.setMessage("PLZ");
        this.txtZIP.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtZIP.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String currZip = ((Text)e.widget).getText();
                if (currZip == null || currZip.length() < 4) {
                    return;
                }
                StammDatenComposite.this.streetIP.setZip(currZip);
            }
        });
        ContentProposalAdapter cpaZip = new ContentProposalAdapter((Control)this.txtZIP, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.zipIP, null, null);
        cpaZip.setProposalAcceptanceStyle(2);
        cpaZip.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                StammDatenComposite.this.txtCity.setText(StammDatenComposite.this.zipIP.findCityNameForZip(proposal.getContent()));
            }
        });
        Label lblImageCountry = new Label((Composite)grpAddress, 0);
        GridData gd_lblImageCountry = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblImageCountry.widthHint = 55;
        lblImageCountry.setLayoutData((Object)gd_lblImageCountry);
        this.txtStreet = new Text((Composite)grpAddress, 2048);
        this.txtStreet.setMessage("Strasse, Hausnummer");
        this.txtStreet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ContentProposalAdapter cpaStreet = new ContentProposalAdapter((Control)this.txtStreet, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.streetIP, null, null);
        cpaStreet.setProposalAcceptanceStyle(2);
        Group grpKontaktdaten = new Group((Composite)this, 0);
        grpKontaktdaten.setText("Kontaktdaten");
        grpKontaktdaten.setLayout((Layout)new GridLayout(4, false));
        grpKontaktdaten.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        Label lblImgPhone = new Label((Composite)grpKontaktdaten, 0);
        lblImgPhone.setImage(Images.IMG_TELEPHONE.getImage());
        lblImgPhone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtTelefon = new Text((Composite)grpKontaktdaten, 2048);
        this.txtTelefon.setMessage("Telefon-Nummer");
        this.txtTelefon.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtTelefon.addFocusListener(this.preDialFocuListener);
        Label lblImgePhone2 = new Label((Composite)grpKontaktdaten, 0);
        lblImgePhone2.setImage(Images.IMG_TELEPHONE.getImage());
        lblImgePhone2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtTelefon2 = new Text((Composite)grpKontaktdaten, 2048);
        this.txtTelefon2.setMessage("Telefon-Nummer");
        this.txtTelefon2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtTelefon2.addFocusListener(this.preDialFocuListener);
        Label lblImgMobilePhone = new Label((Composite)grpKontaktdaten, 0);
        lblImgMobilePhone.setImage(Images.IMG_MOBILEPHONE.getImage());
        lblImgMobilePhone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtMobil = new Text((Composite)grpKontaktdaten, 2048);
        this.txtMobil.setMessage("Handy-Nummer");
        this.txtMobil.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtMobil.addFocusListener(this.preDialFocuListener);
        Label lblImgFax = new Label((Composite)grpKontaktdaten, 0);
        lblImgFax.setImage(Images.IMG_FAX.getImage());
        lblImgFax.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.txtFax = new Text((Composite)grpKontaktdaten, 2048);
        this.txtFax.setMessage("Fax-Nummer");
        this.txtFax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFax.addFocusListener(this.preDialFocuListener);
        this.btnEmail = new Button((Composite)grpKontaktdaten, 0x800000);
        this.btnEmail.setImage(Images.IMG_MAIL.getImage());
        this.btnEmail.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnEmail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    URI uriMailTo = new URI("mailto", StammDatenComposite.this.txtEmail.getText(), null);
                    Desktop.getDesktop().mail(uriMailTo);
                }
                catch (IOException | URISyntaxException ex) {
                    log.warn("Error opening URI", (Throwable)ex);
                }
            }
        });
        this.txtEmail = new Text((Composite)grpKontaktdaten, 2048);
        this.txtEmail.setMessage("E-Mail Adresse");
        this.txtEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnWebsite = new Button((Composite)grpKontaktdaten, 0x800000);
        this.btnWebsite.setImage(Images.IMG_WEB.getImage());
        this.btnWebsite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnWebsite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    URI uriURL = new URI(StammDatenComposite.this.txtWebsite.getText());
                    if (!uriURL.isAbsolute()) {
                        uriURL = new URI("http://" + StammDatenComposite.this.txtWebsite.getText());
                    }
                    Desktop.getDesktop().browse(uriURL);
                }
                catch (IOException | URISyntaxException ex) {
                    log.warn("Error opening URI", (Throwable)ex);
                }
            }
        });
        this.txtWebsite = new Text((Composite)grpKontaktdaten, 2048);
        this.txtWebsite.setMessage("Webseite");
        this.txtWebsite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpNotes = new Group((Composite)this, 0);
        grpNotes.setLayout((Layout)new GridLayout(1, false));
        grpNotes.setLayoutData((Object)new GridData(4, 4, true, false, 7, 1));
        grpNotes.setText("Notizen");
        this.txtNotes = new Text((Composite)grpNotes, 576);
        GridData gd_txtNotes = new GridData(4, 4, true, true, 1, 1);
        gd_txtNotes.heightHint = (int)(5.0f * this.txtNotes.getFont().getFontData()[0].height);
        this.txtNotes.setLayoutData((Object)gd_txtNotes);
        this.initDataBindings();
    }

    @Override
    public void setContact(IContact k) {
        this.contact = k;
        this.contactObservable.setValue((Object)this.contact);
        if (this.contact.isPerson()) {
            this.lblContactType.setImage(this.tdlp.getColumnImage(this.contact, 0));
            this.comboViewerSex.getCombo().setVisible(true);
            this.gd_comboSex.exclude = false;
            this.txtTitleBack.setVisible(true);
            this.gd_txtTitleBack.exclude = false;
            this.txtTitleFront.setVisible(true);
            this.gd_txtTitleFront.exclude = false;
            this.dateTimeDob.setVisible(true);
            this.gd_dateTimeDob.exclude = false;
            this.lblHeadline.setText(PERSON_LABEL);
            this.txtFirstName.setMessage("Vorname");
            this.txtFamilyName.setMessage("Nachname");
            if (this.contact.getCode() != null) {
                this.lblCode.setText("#" + this.contact.getCode());
            } else {
                this.lblCode.setText("");
            }
        }
        if (this.contact.isOrganization()) {
            this.lblContactType.setImage(this.tdlp.getColumnImage(this.contact, 0));
            this.comboViewerSex.getCombo().setVisible(false);
            this.gd_comboSex.exclude = true;
            this.txtTitleFront.setVisible(false);
            this.gd_txtTitleFront.exclude = true;
            this.txtTitleBack.setVisible(false);
            this.gd_txtTitleBack.exclude = true;
            this.dateTimeDob.setVisible(false);
            this.gd_dateTimeDob.exclude = true;
            this.txtFirstName.setMessage("Bezeichnung 1");
            this.txtFamilyName.setMessage("Bezeichnung 2");
            this.lblHeadline.setText(ORGANIZATION_LABEL);
            this.lblCode.setText("");
        }
        this.layout();
    }

    protected void initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        Text[] control = new Text[]{this.txtFirstName, this.txtFamilyName, this.txtZIP, this.txtCity, this.txtStreet, this.txtTelefon, this.txtTelefon2, this.txtFax, this.txtEmail, this.txtWebsite, this.txtMobil, this.txtNotes};
        String[] property = new String[]{"description2", "description1", "zip", "city", "street", "phone1", "phone2", "fax", "email", "website", "mobile", "comment"};
        int i = 0;
        while (i < control.length) {
            this.bindValue(control[i], property[i], bindingContext);
            ++i;
        }
        IViewerObservableValue countryObserver = ViewersObservables.observeSingleSelection((Viewer)this.comboViewerCountry);
        bindingContext.bindValue((IObservableValue)countryObserver, PojoObservables.observeDetailValue((IObservableValue)this.contactObservable, (String)"country", Country.class), null, null);
    }
}

