/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.test.initializer;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.builder.ILabItemBuilder;
import ch.elexis.core.model.builder.ILabResultBuilder;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.test.initializer.ConfigInitializer;
import ch.elexis.core.test.util.TestUtil;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.VersionedResource;
import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatabaseInitializer {
    private static Logger logger = LoggerFactory.getLogger(TestDatabaseInitializer.class);
    private static boolean isDbInitialized = false;
    private static IUser user;
    private static boolean isPatientInitialized;
    private static IPatient patient;
    private static boolean isOrganizationInitialized;
    private static IOrganization organization;
    private static boolean isMandantInitialized;
    private static IMandator mandant;
    private ILaboratory laboratory;
    private ILaboratory laboratory2;
    private static boolean isArticleInitialized;
    private static IArticle article;
    private static boolean isFallInitialized;
    private static ICoverage fall;
    private static boolean isBehandlungInitialized;
    private static IEncounter behandlung;
    private static boolean isILabResultInitialized;
    private static List<ILabResult> labResults;
    private static ILabItem labItem;
    private static boolean isPrescriptionInitialized;
    private static IPrescription prescription;
    private static boolean isArtikelstammTableInitialized;
    private static boolean isLaborItemsOrdersResultsInitialized;
    private static boolean isLaborTarif2009Initialized;
    private static boolean isTarmedInitialized;
    private static boolean isPhysioLeistungInitialized;
    private static boolean isAgendaInitialized;
    private static boolean isRemindersInitialized;
    private static boolean isLeistungsblockInitialized;
    private IModelService modelService;
    private IElexisEntityManager entityManager;
    private IConfigService configService;
    private static IXidService xidService;

    static {
        isPatientInitialized = false;
        isOrganizationInitialized = false;
        isMandantInitialized = false;
        isFallInitialized = false;
        isBehandlungInitialized = false;
        isILabResultInitialized = false;
        labResults = new ArrayList<ILabResult>();
        isPrescriptionInitialized = false;
        isArtikelstammTableInitialized = false;
        isLaborItemsOrdersResultsInitialized = false;
        isLaborTarif2009Initialized = false;
        isTarmedInitialized = false;
        isPhysioLeistungInitialized = false;
        isAgendaInitialized = false;
        isRemindersInitialized = false;
        isLeistungsblockInitialized = false;
    }

    public TestDatabaseInitializer(IModelService modelService, IElexisEntityManager entityManager) {
        this.modelService = modelService;
        this.entityManager = entityManager;
    }

    public synchronized void initializeDb() throws IOException, SQLException {
        this.initializeDb(this.configService);
    }

    public void setConfigService(IConfigService configService) {
        this.configService = configService;
    }

    public void initializeDb(IConfigService configService) throws IOException, SQLException {
        if (!isDbInitialized) {
            this.entityManager.getEntityManager();
            this.executeScript("test_initUser", "/rsc/dbScripts/User.sql");
            this.executeScript("test_initRoles", "/rsc/dbScripts/Role.sql");
            this.executeScript("test_initSampleContacts", "/rsc/dbScripts/sampleContacts.sql");
            this.executeScript("test_initBillingVKPreise", "/rsc/dbScripts/BillingVKPreise.sql");
            this.executeScript("test_initStickers", "/rsc/dbScripts/Etiketten.sql");
            if (configService != null) {
                new ConfigInitializer().initializeConfiguration(configService);
            }
            isDbInitialized = true;
        } else {
            logger.error("No connection available!");
        }
    }

    public synchronized void initializeArtikelstammTable() throws IOException {
        if (!isArtikelstammTableInitialized) {
            isArtikelstammTableInitialized = this.executeScript("test_initArtikelstammItem", "/rsc/dbScripts/ArtikelstammItem.sql");
        }
    }

    private boolean executeScript(String liquibase_id, String scriptLocation) throws IOException {
        boolean result = this.entityManager.executeSQLScript(liquibase_id, TestUtil.loadFile(this.getClass(), scriptLocation));
        if (!result) {
            throw new IOException("Error executing script in [" + scriptLocation + "]");
        }
        return true;
    }

    public synchronized void initializeAgendaTable() throws IOException, SQLException {
        this.initializeDb();
        if (!isAgendaInitialized) {
            isAgendaInitialized = this.executeScript("test_initAgenda", "/rsc/dbScripts/Agenda.sql");
        }
    }

    public synchronized void initializeLaborTarif2009Tables() throws IOException, SQLException {
        this.initializeDb();
        if (!isLaborTarif2009Initialized) {
            isLaborTarif2009Initialized = this.executeScript("test_initLaborTarif2009", "/rsc/dbScripts/LaborTarif2009.sql");
        }
    }

    public synchronized void initializeTarmedTables() throws IOException, SQLException {
        this.initializeDb();
        if (!isTarmedInitialized) {
            isTarmedInitialized = this.executeScript("test_initTarmed", "/rsc/dbScripts/Tarmed.sql");
            isTarmedInitialized = this.executeScript("test_initTarmedKumulation", "/rsc/dbScripts/TarmedKumulation.sql");
            isTarmedInitialized = this.executeScript("test_initTarmedExtension", "/rsc/dbScripts/TarmedExtension.sql");
            isTarmedInitialized = this.executeScript("test_initTarmedGroup", "/rsc/dbScripts/TarmedGroup.sql");
            isTarmedInitialized = this.executeScript("test_initTarmedDefinitionen", "/rsc/dbScripts/TarmedDefinitionen.sql");
        }
    }

    public synchronized void initializeArzttarifePhysioLeistungTables() throws IOException, SQLException {
        this.initializeDb();
        if (!isPhysioLeistungInitialized) {
            isPhysioLeistungInitialized = this.executeScript("test_initArzttarifePhysio", "/rsc/dbScripts/ArzttarifePhysio.sql");
        }
    }

    public synchronized void initializeLeistungsblockTables() throws IOException, SQLException {
        this.initializeDb();
        if (!isLeistungsblockInitialized) {
            isLeistungsblockInitialized = this.executeScript("test_initLeistungsblock", "/rsc/dbScripts/Leistungsblock.sql");
        }
    }

    public synchronized void initializeLaborItemsOrdersResults() throws IOException, SQLException {
        this.initializeDb();
        if (!isLaborItemsOrdersResultsInitialized) {
            isLaborItemsOrdersResultsInitialized = this.executeScript("test_LaborItemsWerteResults", "/rsc/dbScripts/LaborItemsWerteResults.sql");
        }
    }

    public synchronized void initializeReminders() throws IOException, SQLException {
        this.initializeDb();
        if (!isRemindersInitialized) {
            isRemindersInitialized = this.executeScript("test_Reminder", "/rsc/dbScripts/Reminder.sql");
        }
    }

    public synchronized void initializePatient() throws IOException, SQLException {
        if (!isDbInitialized) {
            this.initializeDb();
        }
        if (!isPatientInitialized) {
            patient = (IPatient)new IContactBuilder.PatientBuilder(this.modelService, "Test", "Patient", LocalDate.of(1990, 1, 1), Gender.FEMALE).build();
            patient.setPhone1("+01555123");
            patient.setMobile("+01444123");
            patient.setCity("City");
            patient.setZip("123");
            patient.setStreet("Street 1");
            patient.setDiagnosen("Test Diagnose 1\nTest Diagnose 2");
            this.modelService.save((Identifiable)patient);
            this.addAHVNumber(patient, 1);
            isPatientInitialized = true;
        }
    }

    public IPatient getPatient() {
        return patient;
    }

    private void addAHVNumber(IPatient kontakt, int index) {
        String country = "756";
        String number = String.format("%09d", index);
        StringBuilder ahvBuilder = new StringBuilder(String.valueOf(country) + number);
        ahvBuilder.append(this.getAHVCheckNumber(ahvBuilder.toString()));
        kontakt.addXid("www.ahv.ch/xid", ahvBuilder.toString(), true);
    }

    private String getAHVCheckNumber(String string) {
        int sum = 0;
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(string.length() - 1 - i);
            int intValue = Character.getNumericValue(character);
            sum = i % 2 == 0 ? (sum += intValue * 3) : (sum += intValue);
            ++i;
        }
        return Integer.toString(sum % 10);
    }

    public synchronized void initializeOrganization() throws IOException, SQLException {
        if (!isDbInitialized) {
            this.initializeDb();
        }
        if (!isOrganizationInitialized) {
            organization = (IOrganization)new IContactBuilder.OrganizationBuilder(this.modelService, "Test Organization").build();
            organization.setPhone1("+01555345");
            organization.setMobile("+01444345");
            organization.setCity("City");
            organization.setZip("123");
            organization.setStreet("Street 10");
            this.modelService.save((Identifiable)organization);
            isOrganizationInitialized = true;
        }
    }

    public static IOrganization getOrganization() {
        return organization;
    }

    public synchronized void initializeMandant() throws IOException, SQLException {
        if (!isDbInitialized) {
            this.initializeDb();
        }
        if (!isMandantInitialized) {
            IPerson mandantPerson = (IPerson)new IContactBuilder.PersonBuilder(this.modelService, "Test", "Mandant", LocalDate.of(1970, 1, 1), Gender.MALE).mandator().buildAndSave();
            mandant = (IMandator)this.modelService.load(mandantPerson.getId(), IMandator.class).get();
            mandant.setPhone1("+01555234");
            mandant.setMobile("+01444234");
            mandant.setCity("City");
            mandant.setZip("123");
            mandant.setStreet("Street 100");
            mandant.setUser(true);
            this.modelService.save((Identifiable)mandant);
            user = (IUser)new IUserBuilder(this.modelService, "tst", (IContact)mandantPerson).buildAndSave();
            Optional doctorRole = this.modelService.load("doctor", IRole.class);
            if (doctorRole.isPresent()) {
                user.addRole((IRole)doctorRole.get());
            }
            this.modelService.save((Identifiable)user);
            mandant.addXid("www.xid.ch/id/ean", "2000000000002", true);
            mandant.addXid("www.xid.ch/id/ksk", "C000002", true);
            isMandantInitialized = true;
        }
    }

    public static IMandator getMandant() {
        return mandant;
    }

    public static IUser getUser() {
        return user;
    }

    public synchronized void initializePrescription() throws IOException, SQLException {
        if (!isDbInitialized) {
            this.initializeDb();
        }
        if (!isPatientInitialized) {
            this.initializePatient();
        }
        if (!isArticleInitialized) {
            article = (IArticle)this.modelService.create(IArticle.class);
            article.setName("test article");
            article.setCode("123456789");
            article.setTyp(ArticleTyp.EIGENARTIKEL);
            article.setGtin("0000001111111");
            article.setPackageSize(12);
            article.setSellingSize(12);
            this.modelService.save((Identifiable)article);
            isArticleInitialized = true;
        }
        if (!isPrescriptionInitialized) {
            prescription = (IPrescription)new IPrescriptionBuilder(this.modelService, null, article, patient, "1-1-1-1").buildAndSave();
            isPrescriptionInitialized = true;
        }
    }

    public synchronized void initializeFall() throws IOException, SQLException {
        if (!isPatientInitialized) {
            this.initializePatient();
        }
        if (!isOrganizationInitialized) {
            this.initializeOrganization();
        }
        if (!isFallInitialized) {
            fall = (ICoverage)new ICoverageBuilder(this.modelService, patient, "Test Fall", "reason", "method").build();
            fall.setCostBearer((IContact)organization);
            fall.setInsuranceNumber("1234-5678");
            fall.setDateFrom(LocalDate.of(2016, Month.SEPTEMBER, 1));
            this.modelService.save((Identifiable)fall);
            patient = (IPatient)this.modelService.load(patient.getId(), IPatient.class).get();
            isFallInitialized = true;
        }
    }

    public static ICoverage getFall() {
        return fall;
    }

    public void initializeBehandlung() throws IOException, SQLException {
        if (!isMandantInitialized) {
            this.initializeMandant();
        }
        if (!isFallInitialized) {
            this.initializeFall();
        }
        if (!isBehandlungInitialized) {
            behandlung = (IEncounter)new IEncounterBuilder(this.modelService, TestDatabaseInitializer.getFall(), TestDatabaseInitializer.getMandant()).buildAndSave();
            behandlung.setDate(LocalDate.of(2016, Month.SEPTEMBER, 21));
            VersionedResource vr = VersionedResource.load(null);
            vr.update("Test consultation\nWith some test text.", "Administrator");
            vr.update("Test consultation\n pdate done by user", "user");
            behandlung.setVersionedEntry(vr);
            this.modelService.save((Identifiable)behandlung);
            isBehandlungInitialized = true;
        }
    }

    public static IEncounter getBehandlung() {
        return behandlung;
    }

    public synchronized void initializeLabResult() throws IOException, SQLException {
        if (!isPatientInitialized) {
            this.initializePatient();
        }
        if (!isILabResultInitialized) {
            TestDatabaseInitializer.getXidService().localRegisterXIDDomainIfNotExists("www.elexis.ch/xid/kontakt/lab/sendingfacility", "Sendende Institution", 1);
            this.laboratory = (ILaboratory)new IContactBuilder.LaboratoryBuilder(this.modelService, "Labor Test").build();
            this.laboratory.setDescription2("Test");
            this.modelService.save((Identifiable)this.laboratory);
            this.laboratory2 = (ILaboratory)new IContactBuilder.LaboratoryBuilder(this.modelService, "Labor Test2").build();
            this.laboratory2.setDescription2("Test2");
            Assert.assertTrue((boolean)this.laboratory2.addXid("www.elexis.ch/xid/kontakt/lab/sendingfacility", "ZURANA", true));
            this.modelService.save((Identifiable)this.laboratory2);
            labItem = new ILabItemBuilder(this.modelService, "TEST NUMERIC", "Test Laboratory", ">1", "3-3.5", "unit", LabItemTyp.NUMERIC, "group", 1).origin((IContact)this.laboratory, "TEST NUMERIC", true).buildAndSave();
            labItem.setExport("vitolabkey:1,2");
            this.modelService.save((Identifiable)labItem);
            ILabMapping mapping = (ILabMapping)this.modelService.create(ILabMapping.class);
            mapping.setOrigin((IContact)this.laboratory2);
            mapping.setItemName("TEST_NUMERIC_EXT");
            this.modelService.save((Identifiable)mapping);
            this.modelService.save((Identifiable)labItem);
            ILabItem textILabItem = new ILabItemBuilder(this.modelService, "TEST TEXT", "Test Laboratory", null, null, "unit", LabItemTyp.TEXT, "group", 2).origin((IContact)this.laboratory, "Test Laboratory", true).buildAndSave();
            this.modelService.save((Identifiable)labItem);
            ILabResult labResult = (ILabResult)new ILabResultBuilder(this.modelService, labItem, patient).build();
            labResult.setObservationTime(LocalDateTime.of(2016, Month.DECEMBER, 14, 17, 44, 25));
            labResult.setUnit("u");
            labResult.setReferenceMale("<1");
            labResult.setReferenceFemale("1-1.5");
            labResult.setOrigin((IContact)this.laboratory);
            labResult.setResult("2");
            labResult.setComment("no comment");
            this.modelService.save((Identifiable)labResult);
            labResults.add(labResult);
            labResult = (ILabResult)new ILabResultBuilder(this.modelService, labItem, patient).build();
            labResult.setObservationTime(LocalDateTime.of(2016, Month.DECEMBER, 15, 10, 10, 30));
            labResult.setOrigin((IContact)this.laboratory);
            labResult.setResult("2");
            labResult.setComment("no comment");
            this.modelService.save((Identifiable)labResult);
            labResults.add(labResult);
            labResult = (ILabResult)new ILabResultBuilder(this.modelService, labItem, patient).build();
            labResult.setObservationTime(LocalDateTime.of(2017, Month.FEBRUARY, 28, 12, 59, 23));
            labResult.setOrigin((IContact)this.laboratory);
            labResult.setResult("124/79");
            labResult.setUnit("Bloodpressure");
            this.modelService.save((Identifiable)labResult);
            labResults.add(labResult);
            labResult = (ILabResult)new ILabResultBuilder(this.modelService, textILabItem, patient).build();
            labResult.setObservationTime(LocalDateTime.of(2017, Month.FEBRUARY, 28, 10, 2, 23));
            labResult.setOrigin((IContact)this.laboratory);
            labResult.setResult("(Text)");
            labResult.setComment("The Text Result ...");
            this.modelService.save((Identifiable)labResult);
            labResults.add(labResult);
            isILabResultInitialized = true;
        }
    }

    public static IXidService getXidService() {
        if (xidService == null) {
            xidService = (IXidService)OsgiServiceUtil.getService(IXidService.class).orElseThrow(() -> new IllegalStateException("No XidService available"));
        }
        return xidService;
    }

    public ILabItem getILabItem() {
        return labItem;
    }

    public ILaboratory getLaboratory() {
        return this.laboratory;
    }

    public ILaboratory getLaboratory2() {
        return this.laboratory2;
    }

    public static List<ILabResult> getLabResults() {
        return labResults;
    }

    public IArticle getArticle() {
        return article;
    }
}

