/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.test.context;

import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.test.context.TestContext;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@Component
public class TestContextService
implements IContextService {
    private ThreadLocal<IContext> rootContext;
    @Reference
    private EventAdmin eventAdmin;
    private ConcurrentHashMap<String, TestContext> contexts;

    @Activate
    public void activate() {
        this.rootContext = new ThreadLocal<IContext>(){

            @Override
            protected IContext initialValue() {
                return new TestContext();
            }
        };
        this.contexts = new ConcurrentHashMap();
    }

    public IContext getRootContext() {
        return this.rootContext.get();
    }

    public Optional<IContext> getNamedContext(String name) {
        return Optional.ofNullable((IContext)this.contexts.get(name));
    }

    public IContext createNamedContext(String name) {
        TestContext context = new TestContext((TestContext)this.rootContext.get(), name);
        this.contexts.put(name, context);
        return context;
    }

    public void releaseContext(String name) {
        TestContext context = this.contexts.get(name);
        if (context != null) {
            context.setParent(null);
            this.contexts.remove(name);
        }
    }

    public void postEvent(String topic, Object object) {
        if (this.eventAdmin == null) {
            throw new IllegalStateException("No EventAdmin available");
        }
        HashMap<String, Object> properites = new HashMap<String, Object>();
        properites.put("org.eclipse.e4.data", object);
        Event event = new Event(topic, properites);
        this.eventAdmin.postEvent(event);
    }

    public void sendEvent(String topic, Object object) {
        if (this.eventAdmin == null) {
            throw new IllegalStateException("No EventAdmin available");
        }
        HashMap<String, Object> properites = new HashMap<String, Object>();
        properites.put("org.eclipse.e4.data", object);
        Event event = new Event(topic, properites);
        this.eventAdmin.sendEvent(event);
    }
}

