/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.test.context;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContext;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class TestContext
implements IContext {
    private ConcurrentHashMap<String, Object> context = new ConcurrentHashMap();
    private TestContext parent;

    public TestContext() {
        this(null, "root");
    }

    public TestContext(TestContext parent, String name) {
        this.parent = parent;
    }

    public <T> Optional<T> getTyped(Class<T> clazz) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(clazz.getName()));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getTyped(clazz);
        }
        return ret;
    }

    public void setTyped(Object object) {
        if (object != null) {
            Optional<Class<?>> modelInterface;
            if (object instanceof IUser) {
                IContact userContact = ((IUser)object).getAssignedContact();
                this.setNamed("ch.elexis.core.services.icontext.active.usercontact", userContact);
            }
            if (object.equals(this.context.get((modelInterface = this.getModelInterface(object)).get().getName()))) {
                return;
            }
            if (modelInterface.isPresent()) {
                this.context.put(modelInterface.get().getName(), object);
            } else {
                this.context.put(object.getClass().getName(), object);
            }
        }
    }

    private Optional<Class<?>> getModelInterface(Object object) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = object.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (interfaze.getName().startsWith("ch.elexis.core.model") && !interfaze.getName().contains("Identifiable")) {
                return Optional.of(interfaze);
            }
            ++n2;
        }
        return Optional.empty();
    }

    public void removeTyped(Class<?> clazz) {
        this.context.remove(clazz.getName());
    }

    public Optional<?> getNamed(String name) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(name));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getNamed(name);
        }
        return ret;
    }

    public void setNamed(String name, Object object) {
        if (object == null) {
            this.context.remove(name);
        } else {
            if (object.equals(this.context.get(name))) {
                return;
            }
            this.context.put(name, object);
        }
    }

    public void setParent(TestContext parent) {
        this.parent = parent;
    }

    public String getStationIdentifier() {
        return null;
    }
}

