/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.internal.service.TaskServiceImpl;
import ch.elexis.core.tasks.internal.service.vfs.FilesystemChangeWatcherTimerTask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.utils.CoreUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class FilesystemChangeWatcher {
    private final TaskServiceImpl taskService;
    private final IVirtualFilesystemService virtualFileSystemService;
    private Timer timer;
    private FilesystemChangeWatcherTimerTask timerTask;

    public FilesystemChangeWatcher(TaskServiceImpl taskService, IVirtualFilesystemService virtualFileSystemService) {
        this.taskService = taskService;
        this.virtualFileSystemService = virtualFileSystemService;
    }

    private synchronized void startPolling() {
        if (this.timer == null) {
            this.timer = new Timer("taskservice-filesystemchange-poller");
            this.timerTask = new FilesystemChangeWatcherTimerTask(this.taskService, this.virtualFileSystemService);
            long period = CoreUtil.isTestMode() ? 1000 : 30000;
            this.timer.schedule((TimerTask)this.timerTask, 0L, period);
        }
    }

    public synchronized void stopPolling() {
        this.timer.cancel();
        this.timerTask = null;
        this.timer = null;
    }

    public void incur(ITaskDescriptor taskDescriptor) {
        this.startPolling();
        Map<String, String> triggerParameters = taskDescriptor.getTriggerParameters();
        String url = triggerParameters.get("url");
        String fileExtensionFilter = triggerParameters.get("fileExtensionFilter");
        this.timerTask.incur(taskDescriptor.getId(), url, fileExtensionFilter);
    }

    public void release(ITaskDescriptor taskDescriptor) {
        this.timerTask.release(taskDescriptor.getId());
        if (this.getIncurred().isEmpty()) {
            this.stopPolling();
        }
    }

    public Set<String[]> getIncurred() {
        HashSet<String[]> incurred = new HashSet<String[]>();
        if (this.timerTask != null) {
            incurred.addAll(this.timerTask.getIncurred());
        }
        return incurred;
    }
}

