/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.runnables;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.internal.service.TaskServiceHolder;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskTriggerType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;

@Deprecated(forRemoval=true)
public class TriggerTaskForEveryFileInDirectoryRunnable
implements IIdentifiedRunnable {
    public static final String RESULT_KEY_LIST_ITASK_TASKS_TRIGGERED = "tasksTriggered";
    public static final String RCP_STRING_FILE_EXTENSION_FILTER = "fileExtensionFilter";
    private String taskDescriptorReferenceId;
    private Logger logger;
    private IVirtualFilesystemService virtualFilsystemService;

    public TriggerTaskForEveryFileInDirectoryRunnable(IVirtualFilesystemService virtualFilsystemService) {
        this.virtualFilsystemService = virtualFilsystemService;
    }

    public String getId() {
        return "triggerTaskForEveryFile";
    }

    public String getLocalizedDescription() {
        return "Execute a task on every file found in a given directory.";
    }

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> runContext = new HashMap<String, Serializable>();
        runContext.put("url", (Serializable)((Object)"missingRequired"));
        runContext.put("taskDescriptorReferenceId", (Serializable)((Object)"missingRequired"));
        runContext.put(RCP_STRING_FILE_EXTENSION_FILTER, null);
        return runContext;
    }

    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles;
        this.logger = logger;
        String urlString = (String)((Object)runContext.get("url"));
        this.taskDescriptorReferenceId = (String)((Object)runContext.get("taskDescriptorReferenceId"));
        String fileExtensionFilter = (String)((Object)runContext.get(RCP_STRING_FILE_EXTENSION_FILTER));
        ArrayList<String> tasksTriggered = new ArrayList<String>();
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle of = this.virtualFilsystemService.of(urlString);
            listHandles = StringUtils.isNotBlank((CharSequence)fileExtensionFilter) ? of.listHandles(handle -> fileExtensionFilter.equalsIgnoreCase(handle.getExtension())) : of.listHandles();
        }
        catch (IOException e) {
            logger.debug("--DEBUG--", (Throwable)e);
            throw new TaskException(6, e.getMessage());
        }
        IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = listHandles;
        int n = listHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = iVirtualFilesystemHandleArray[n2];
            tasksTriggered.add(this.runTaskForFile(fileHandle.getAbsolutePath()).getId());
            ++n2;
        }
        if (tasksTriggered.isEmpty()) {
            return Collections.singletonMap("markerDoNotPersist", true);
        }
        return Collections.singletonMap(RESULT_KEY_LIST_ITASK_TASKS_TRIGGERED, (Serializable)tasksTriggered);
    }

    private ITask runTaskForFile(String url) throws TaskException {
        this.logger.debug("Triggering task reference id [{}] for url [{}]", (Object)this.taskDescriptorReferenceId, (Object)url);
        try {
            ITaskService taskService = TaskServiceHolder.get();
            Map<String, String> runContext = Collections.singletonMap("url", url);
            return taskService.trigger(this.taskDescriptorReferenceId, null, TaskTriggerType.OTHER_TASK, runContext);
        }
        catch (IllegalStateException e) {
            throw new TaskException(6, (Throwable)e);
        }
    }
}

