/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.runnables;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IVirtualFilesystemService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;

public class DeleteFileIdentifiedRunnable
implements IIdentifiedRunnable {
    private IVirtualFilesystemService virtualFilesystemService;

    public DeleteFileIdentifiedRunnable(IVirtualFilesystemService virtualFilesystemService) {
        this.virtualFilesystemService = virtualFilesystemService;
    }

    public String getId() {
        return "deleteFile";
    }

    public Map<String, Serializable> run(Map<String, Serializable> context, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        String eventFilePath = (String)((Object)context.get("url"));
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = this.virtualFilesystemService.of(eventFilePath);
            vfsHandle.delete();
            logger.info("Deleted {}", (Object)eventFilePath);
        }
        catch (IOException e) {
            throw new TaskException(6, "Error deleting file [" + eventFilePath + "]", (Throwable)e);
        }
        return null;
    }

    public String getLocalizedDescription() {
        return "Delete a single file";
    }

    public Map<String, Serializable> getDefaultRunContext() {
        return Collections.singletonMap("url", "missingRequired");
    }
}

