/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.internal.contributors;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.spotlight.ISpotlightResult;
import ch.elexis.core.spotlight.ISpotlightResultContributor;
import ch.elexis.core.spotlight.ISpotlightResultEntry;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PatientCategorySpotlightResultContributor
implements ISpotlightResultContributor {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;

    @Override
    public void computeResult(List<String> stringTerms, List<LocalDate> dateTerms, List<Number> numericTerms, ISpotlightResult spotlightResult, Map<String, String> searchParams) {
        if (searchParams != null && searchParams.containsKey("patientId")) {
            return;
        }
        IQuery query = this.modelService.getQuery(IPatient.class);
        if (stringTerms.size() == 1) {
            query.startGroup();
            query.or((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true);
            query.or((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true);
        } else if (stringTerms.size() > 1) {
            query.startGroup();
            query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true);
            query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(1)) + "%"), true);
            query.startGroup();
            query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(1)) + "%"), true);
            query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true);
            query.orJoinGroups();
        }
        if (!dateTerms.isEmpty()) {
            if (!stringTerms.isEmpty()) {
                query.andJoinGroups();
            }
            query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)dateTerms.get(0));
        }
        if (!numericTerms.isEmpty()) {
            if (!stringTerms.isEmpty() || !dateTerms.isEmpty()) {
                query.andJoinGroups();
            }
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__CODE, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(numericTerms.get(0).intValue()) + "%"));
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.ORDER.ASC);
        query.limit(5);
        List patients = query.execute();
        for (IPatient patient : patients) {
            spotlightResult.addEntry(ISpotlightResultEntry.Category.PATIENT, patient.getLabel(), patient.getId(), patient);
        }
    }
}

