/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class PatientTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Patient";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(PatientAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IPatient patient = context.getTyped(IPatient.class).orElse(null);
        if (patient != null) {
            return Optional.ofNullable(this.replace(patient, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    private String replace(IPatient patient, String lcAttribute) {
        PatientAttribute patientAttribut = (PatientAttribute)this.searchEnum(PatientAttribute.class, lcAttribute);
        switch (patientAttribut) {
            case Anrede: {
                return PersonFormatUtil.getSalutation((IPerson)patient);
            }
            case Name: {
                return patient.getLastName();
            }
            case Vorname: {
                return patient.getFirstName();
            }
            case Anschrift: {
                return AddressFormatUtil.getPostalAddress((IContact)patient, (boolean)true);
            }
            case Anschriftzeile: {
                return AddressFormatUtil.getPostalAddress((IContact)patient, (boolean)false);
            }
        }
        return null;
    }

    private static enum PatientAttribute implements ILocalizedEnum
    {
        Name("Nachname des Patienten"),
        Vorname("Vorname des Patienten"),
        Anrede("Anrede des Patienten"),
        Anschrift("Mehrzeilige Anschrift"),
        Anschriftzeile("Einzeilige Anschrift");

        final String description;

        private PatientAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

