/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class MandantTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Mandant";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(MandantAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IMandator mandantor = context.getTyped(IMandator.class).orElse(null);
        if (mandantor != null) {
            return Optional.ofNullable(this.replace(mandantor, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    private String replace(IMandator mandator, String lcAttribute) {
        MandantAttribute mandantAttribut = (MandantAttribute)this.searchEnum(MandantAttribute.class, lcAttribute);
        switch (mandantAttribut) {
            case Anrede: {
                if (mandator.isPerson()) {
                    return PersonFormatUtil.getSalutation((IPerson)((IPerson)CoreModelServiceHolder.get().load(mandator.getId(), IPerson.class).get()));
                }
                return "";
            }
            case Name: {
                return mandator.getDescription1();
            }
            case Vorname: {
                return mandator.getDescription2();
            }
            case Titel: {
                if (mandator.isPerson()) {
                    return ((IPerson)CoreModelServiceHolder.get().load(mandator.getId(), IPerson.class).get()).getTitel();
                }
            }
            case Anschrift: {
                return AddressFormatUtil.getPostalAddress((IContact)mandator, (boolean)true);
            }
            case Anschriftzeile: {
                return AddressFormatUtil.getPostalAddress((IContact)mandator, (boolean)false);
            }
        }
        return null;
    }

    private static enum MandantAttribute implements ILocalizedEnum
    {
        Name("Nachname des Mandanten"),
        Vorname("Vorname des Mandanten"),
        Titel("Titel des Mandanten"),
        Anrede("Anrede des Mandanten"),
        Anschrift("Mehrzeilige Anschrift"),
        Anschriftzeile("Einzeilige Anschrift");

        final String description;

        private MandantAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

