/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.eenv.AccessTokenUtil;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.representations.AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisEnvironmentService
implements IElexisEnvironmentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String elexisEnvironmentHost;
    private IContextService contextService;
    private IConfigService configService;

    public ElexisEnvironmentService(String elexisEnvironmentHost, IContextService contextService, IConfigService configService) {
        this.elexisEnvironmentHost = elexisEnvironmentHost;
        this.contextService = contextService;
        this.configService = configService;
        LoggerFactory.getLogger(this.getClass()).info("Binding to EE {}", (Object)this.getHostname());
    }

    public String getVersion() {
        return "unknown";
    }

    public String getProperty(String key) {
        String value = System.getenv(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        return this.configService.get(key, null);
    }

    public String getHostname() {
        return this.elexisEnvironmentHost;
    }

    public void loadAccessToken(String username, char[] password) {
        try {
            AuthzClient authzClient = AuthzClient.create((Configuration)this.getKeycloakConfiguration());
            AccessTokenResponse obtainAccessToken = authzClient.obtainAccessToken(username, String.valueOf(password));
            AccessToken keycloakAccessToken = AccessTokenUtil.load(obtainAccessToken.getToken());
            this.contextService.getRootContext().setTyped((Object)keycloakAccessToken);
            this.logger.info("Loaded access-token for user [{}], valid until [{}]", (Object)keycloakAccessToken.getUsername(), (Object)keycloakAccessToken.getExpirationTime());
        }
        catch (Exception e) {
            this.logger.warn("Error obtaining access token", (Throwable)e);
            return;
        }
    }

    private Configuration getKeycloakConfiguration() {
        Configuration keycloakConfiguration = new Configuration();
        keycloakConfiguration.setRealm("ElexisEnvironment");
        keycloakConfiguration.setAuthServerUrl(String.valueOf(this.getKeycloakBaseUrl()) + "/auth");
        keycloakConfiguration.setResource("elexis-rcp-openid");
        keycloakConfiguration.setPublicClient(false);
        keycloakConfiguration.setDisableTrustManager(false);
        String rcpClientSecret = this.getProperty("EE_RCP_OPENID_SECRET");
        keycloakConfiguration.getCredentials().put("secret", rcpClientSecret);
        return keycloakConfiguration;
    }
}

