/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.rgw.tools.PasswordEncryptionService;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class UserService
implements IUserService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;

    public boolean verifyPassword(IUser user, char[] attemptedPassword) {
        boolean ret = false;
        if (user != null) {
            PasswordEncryptionService pes = new PasswordEncryptionService();
            try {
                ret = pes.authenticate(attemptedPassword, user.getHashedPassword(), user.getSalt());
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Error verifying password for user [{}].", (Object)user.getLabel(), (Object)e);
            }
        }
        return ret;
    }

    public void setPasswordForUser(IUser user, String password) {
        if (user != null) {
            PasswordEncryptionService pes = new PasswordEncryptionService();
            try {
                String salt = pes.generateSaltAsHexString();
                String hashed_pw = pes.getEncryptedPasswordAsHexString(password, salt);
                user.setSalt(salt);
                user.setHashedPassword(hashed_pw);
                this.modelService.save((Identifiable)user);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Error setting password for user [{}].", (Object)user.getLabel(), (Object)e);
            }
        }
    }

    public Set<IMandator> getExecutiveDoctorsWorkingFor(IContact user) {
        String mandators = (String)user.getExtInfo((Object)"Mandant");
        if (mandators == null) {
            return Collections.emptySet();
        }
        List allActivateMandators = this.modelService.getQuery(IMandator.class).execute().parallelStream().filter(IMandator::isActive).collect(Collectors.toList());
        List<String> mandatorsIdList = Arrays.asList(mandators.split(","));
        return allActivateMandators.stream().filter(p -> mandatorsIdList.contains(p.getLabel())).collect(Collectors.toSet());
    }

    public Optional<IMandator> getDefaultExecutiveDoctorWorkingFor(IContact userContact) {
        String defaultMandatorId = (String)userContact.getExtInfo((Object)"StdMandant");
        if (StringUtils.isNotEmpty((CharSequence)defaultMandatorId)) {
            return this.modelService.load(defaultMandatorId, IMandator.class);
        }
        if (userContact.isMandator()) {
            return this.modelService.load(userContact.getId(), IMandator.class);
        }
        return Optional.empty();
    }

    public void setDefaultExecutiveDoctorWorkingFor(IContact userContact, IMandator mandator) {
        userContact.setExtInfo((Object)"StdMandant", (Object)mandator.getId());
        CoreModelServiceHolder.get().save((Identifiable)userContact);
    }

    public void addOrRemoveExecutiveDoctorWorkingFor(IContact user, IMandator mandator, boolean add) {
        HashSet<IMandator> mandators = new HashSet<IMandator>(this.getExecutiveDoctorsWorkingFor(user));
        if (add) {
            mandators.add(mandator);
        } else {
            mandators.remove(mandator);
        }
        List edList = mandators.stream().map(p -> p.getLabel()).collect(Collectors.toList());
        user.setExtInfo((Object)"Mandant", (Object)(edList.isEmpty() ? "" : edList.stream().map(o -> o.toString()).reduce((u, t) -> String.valueOf(u) + "," + t).get()));
        CoreModelServiceHolder.get().save((Identifiable)user);
    }

    public List<IUser> getUsersByAssociatedContact(IContact contact) {
        if (contact == null) {
            return Collections.emptyList();
        }
        IQuery qre = this.modelService.getQuery(IUser.class);
        qre.and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.EQUALS, (Object)contact);
        qre.and((EStructuralFeature)ModelPackage.Literals.IUSER__ACTIVE, IQuery.COMPARATOR.EQUALS, (Object)true);
        return qre.execute();
    }

    public Set<String> setUserRoles(IUser user, Set<String> userRoles) {
        LinkedList<IRole> targetUserRoleSet = new LinkedList<IRole>();
        for (String roleId : userRoles) {
            Optional _role = this.modelService.load(roleId, IRole.class);
            if (!_role.isPresent()) continue;
            targetUserRoleSet.add((IRole)_role.get());
        }
        user.setRoles(targetUserRoleSet);
        this.modelService.save((Identifiable)user);
        return targetUserRoleSet.stream().map(r -> r.getId()).collect(Collectors.toSet());
    }
}

