/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.StickerClassLink;
import ch.elexis.core.jpa.entities.StickerObjectLink;
import ch.elexis.core.jpa.entities.StickerObjectLinkId;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@Component
public class StickerService
implements IStickerService {
    @Reference(target="(id=default)")
    private IElexisEntityManager entityManager;
    @Reference
    private IStoreToStringService storeToStringServcie;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private EventAdmin eventAdmin;

    private List<StickerObjectLink> getStickerObjectLinksForId(String id) {
        EntityManager em = (EntityManager)this.entityManager.getEntityManager(true);
        TypedQuery query = em.createNamedQuery("StickerObjectLink.obj", StickerObjectLink.class);
        query.setParameter("obj", (Object)id);
        return query.getResultList();
    }

    private List<StickerObjectLink> getStickerObjectLinksForSticker(ISticker iSticker) {
        EntityManager em = (EntityManager)this.entityManager.getEntityManager(true);
        TypedQuery query = em.createNamedQuery("StickerObjectLink.etikette", StickerObjectLink.class);
        query.setParameter("etikette", (Object)iSticker.getId());
        return query.getResultList();
    }

    private StickerObjectLink getStickerObjectLink(String id, String etikette) {
        EntityManager em = (EntityManager)this.entityManager.getEntityManager(true);
        return (StickerObjectLink)em.find(StickerObjectLink.class, (Object)new StickerObjectLinkId(id, etikette));
    }

    public boolean hasSticker(Identifiable identifiable, ISticker iSticker) {
        List<StickerObjectLink> entries = this.findAttachments(identifiable, iSticker);
        return !entries.isEmpty();
    }

    private List<StickerObjectLink> findAttachments(Identifiable identifiable, ISticker iSticker) {
        EntityManager em = (EntityManager)this.entityManager.getEntityManager(true);
        TypedQuery query = em.createNamedQuery("StickerObjectLink.obj.etikette", StickerObjectLink.class);
        query.setParameter("obj", (Object)identifiable.getId());
        query.setParameter("etikette", (Object)iSticker.getId());
        return query.getResultList();
    }

    public <T> List<T> getObjectsWithSticker(ISticker sticker, Class<T> type) {
        List<StickerObjectLink> objectLinks = this.getStickerObjectLinksForSticker(sticker);
        if (!objectLinks.isEmpty()) {
            return objectLinks.stream().map(ol -> CoreModelServiceHolder.get().load(ol.getObj(), type).orElse(null)).filter(o -> o != null).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<ISticker> getStickers(Identifiable identifiable) {
        if (identifiable == null) {
            return Collections.emptyList();
        }
        List<StickerObjectLink> stickerObjectLinks = this.getStickerObjectLinksForId(identifiable.getId());
        ArrayList<ISticker> loadedStickers = new ArrayList<ISticker>();
        for (StickerObjectLink link : stickerObjectLinks) {
            ISticker sticker = this.loadStickerForStickerObjectLink(link, identifiable);
            if (sticker == null) continue;
            loadedStickers.add(sticker);
        }
        loadedStickers.sort(new StickerSorter());
        return loadedStickers;
    }

    public ISticker getSticker(Identifiable identifiable, ISticker sticker) {
        List<StickerObjectLink> resultList = this.findAttachments(identifiable, sticker);
        if (resultList.isEmpty()) {
            return null;
        }
        StickerObjectLink stickerObjectLink = resultList.get(0);
        return this.loadStickerForStickerObjectLink(stickerObjectLink, identifiable);
    }

    private ISticker loadStickerForStickerObjectLink(StickerObjectLink stickerObjectLink, Identifiable identifiable) {
        ISticker sticker = this.coreModelService.load(stickerObjectLink.getEtikette(), ISticker.class, false, false).orElse(null);
        if (sticker != null) {
            sticker.setAttachedTo(identifiable);
            sticker.setAttachedToData(stickerObjectLink.getData());
            return sticker;
        }
        return null;
    }

    public Optional<ISticker> getSticker(Identifiable identifiable) {
        List<ISticker> stickers = this.getStickers(identifiable);
        if (stickers != null && !stickers.isEmpty()) {
            return Optional.of(stickers.get(0));
        }
        return Optional.empty();
    }

    public void addSticker(ISticker sticker, Identifiable identifiable, String data) {
        EntityManager em = (EntityManager)this.entityManager.getEntityManager(false);
        try {
            StickerObjectLink link = new StickerObjectLink();
            link.setEtikette(sticker.getId());
            link.setObj(identifiable.getId());
            link.setData(data);
            em.getTransaction().begin();
            em.merge((Object)link);
            em.getTransaction().commit();
        }
        finally {
            this.entityManager.closeEntityManager((Object)em);
        }
        this.handleUpdate(identifiable);
    }

    private void handleUpdate(Identifiable identifiable) {
        this.coreModelService.touch(identifiable);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("org.eclipse.e4.data", identifiable.getId());
        map.put("property", "sticker");
        Event event = new Event("info/elexis/model/update", map);
        this.eventAdmin.postEvent(event);
    }

    public void addSticker(ISticker sticker, Identifiable identifiable) {
        this.addSticker(sticker, identifiable, null);
    }

    public void removeSticker(ISticker sticker, Identifiable identifiable) {
        StickerObjectLink stickerObjectLink = this.getStickerObjectLink(identifiable.getId(), sticker.getId());
        if (stickerObjectLink != null) {
            EntityManager em = (EntityManager)this.entityManager.getEntityManager(false);
            try {
                em.getTransaction().begin();
                EntityWithId object = (EntityWithId)em.merge((Object)stickerObjectLink);
                em.remove((Object)object);
                em.getTransaction().commit();
            }
            finally {
                this.entityManager.closeEntityManager((Object)em);
            }
        }
        this.handleUpdate(identifiable);
    }

    private List<StickerClassLink> getStickerClassLinksForSticker(String id) {
        EntityManager em = (EntityManager)this.entityManager.getEntityManager(true);
        TypedQuery query = em.createNamedQuery("StickerClassLink.sticker", StickerClassLink.class);
        query.setParameter("sticker", (Object)id);
        return query.getResultList();
    }

    public boolean isStickerAddableToClass(Class<?> clazz, ISticker sticker) {
        String type = this.getTypeForClass(clazz);
        if (type != null) {
            List<StickerClassLink> classLinks = this.getStickerClassLinksForSticker(sticker.getId());
            for (StickerClassLink stickerClassLink : classLinks) {
                if (!type.equals(stickerClassLink.getObjclass())) continue;
                return true;
            }
        } else {
            throw new IllegalStateException("Could not get type for [" + clazz + "]");
        }
        return false;
    }

    public void setStickerAddableToClass(Class<?> clazz, ISticker sticker) {
        String type = this.getTypeForClass(clazz);
        if (type != null) {
            EntityManager em = (EntityManager)this.entityManager.getEntityManager(false);
            try {
                StickerClassLink link = new StickerClassLink();
                link.setObjclass(type);
                link.setSticker(sticker.getId());
                em.getTransaction().begin();
                em.merge((Object)link);
                em.getTransaction().commit();
            }
            finally {
                this.entityManager.closeEntityManager((Object)em);
            }
        } else {
            throw new IllegalStateException("Could not get type for [" + clazz + "]");
        }
    }

    public List<ISticker> getStickersForClass(Class<?> clazz) {
        String type = this.getTypeForClass(clazz);
        if (type != null) {
            EntityManager em = (EntityManager)this.entityManager.getEntityManager(true);
            TypedQuery query = em.createNamedQuery("StickerClassLink.objclass", StickerClassLink.class);
            query.setParameter("objclass", (Object)type);
            List results = query.getResultList();
            List stickerIds = results.parallelStream().map(item -> item.getSticker()).collect(Collectors.toList());
            return this.coreModelService.findAllById(stickerIds, ISticker.class);
        }
        throw new IllegalStateException("Could not get type for [" + clazz + "]");
    }

    private String getTypeForClass(Class<?> clazz) {
        if (EntityWithId.class.isAssignableFrom(clazz)) {
            return this.storeToStringServcie.getTypeForEntity(clazz);
        }
        if (Identifiable.class.isAssignableFrom(clazz)) {
            return this.storeToStringServcie.getTypeForModel(clazz);
        }
        return null;
    }

    private class StickerSorter
    implements Comparator<ISticker> {
        private StickerSorter() {
        }

        @Override
        public int compare(ISticker s1, ISticker s2) {
            return Integer.valueOf(s2.getImportance()).compareTo(s1.getImportance());
        }
    }
}

