/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component
public class OrderService
implements IOrderService {
    public IOrderEntry findOpenOrderEntryForStockEntry(IStockEntry stockEntry) {
        IArticle article = stockEntry.getArticle();
        if (article != null) {
            String[] articleStoreToStringParts = StoreToStringServiceHolder.getStoreToString(article).split("::");
            IQuery query = CoreModelServiceHolder.get().getQuery(IOrderEntry.class);
            query.and("stockid", IQuery.COMPARATOR.EQUALS, (Object)stockEntry.getStock().getId());
            query.and("articleType", IQuery.COMPARATOR.EQUALS, (Object)articleStoreToStringParts[0]);
            query.and("articleId", IQuery.COMPARATOR.EQUALS, (Object)articleStoreToStringParts[1]);
            query.and("state", IQuery.COMPARATOR.NOT_EQUALS, (Object)OrderEntryState.DONE.getValue());
            List orderEntries = query.execute();
            if (!orderEntries.isEmpty()) {
                return (IOrderEntry)orderEntries.get(0);
            }
        }
        return null;
    }

    public IOrderEntry addRefillForStockEntryToOrder(IStockEntry ise, IOrder order) {
        int toOrder;
        int current = ise.getCurrentStock();
        int max = ise.getMaximumStock();
        if (max == 0) {
            max = ise.getMinimumStock();
        }
        if ((toOrder = max - current) > 0) {
            IOrderEntry orderEntry = order.addEntry(ise.getArticle(), ise.getStock(), ise.getProvider(), toOrder);
            CoreModelServiceHolder.get().save((Identifiable)orderEntry);
            return orderEntry;
        }
        return null;
    }
}

